Object.defineProperty(exports, "__esModule", { value: true });
exports.init = exports.defaultIntegrations = void 0;
const common_1 = require("../common");
(0, common_1.ensureProcess)('main');
const node_1 = require("@sentry/node");
const electron_1 = require("electron");
const context_1 = require("./context");
const integrations_1 = require("./integrations");
const ipc_1 = require("./ipc");
const electron_offline_net_1 = require("./transports/electron-offline-net");
const version_1 = require("./version");
exports.defaultIntegrations = [
    new integrations_1.SentryMinidump(),
    new integrations_1.ElectronBreadcrumbs(),
    new integrations_1.Net(),
    new integrations_1.MainContext(),
    new integrations_1.ChildProcess(),
    new integrations_1.OnUncaughtException(),
    new integrations_1.PreloadInjection(),
    new integrations_1.AdditionalContext(),
    new integrations_1.Screenshots(),
    ...node_1.defaultIntegrations.filter((integration) => integration.name !== 'OnUncaughtException' && integration.name !== 'Context'),
];
const defaultOptions = {
    _metadata: { sdk: { name: 'sentry.javascript.electron', version: version_1.SDK_VERSION } },
    ipcMode: common_1.IPCMode.Both,
    getSessions: () => [electron_1.session.defaultSession],
};
/**
 * Initialize Sentry in the Electron main process
 */
function init(userOptions) {
    const options = Object.assign(defaultOptions, userOptions);
    const defaults = exports.defaultIntegrations;
    // If we don't set a release, @sentry/node will automatically fetch from environment variables
    if (options.release === undefined) {
        options.release = (0, context_1.getDefaultReleaseName)();
    }
    // If we don't set an environment, @sentry/core defaults to production
    if (options.environment === undefined) {
        options.environment = (0, context_1.getDefaultEnvironment)();
    }
    // Unless autoSessionTracking is specifically disabled, we track sessions as the
    // lifetime of the Electron main process
    if (options.autoSessionTracking !== false) {
        defaults.push(new integrations_1.MainProcessSession());
        // We don't want nodejs autoSessionTracking
        options.autoSessionTracking = false;
    }
    setDefaultIntegrations(defaults, options);
    if (options.dsn && options.transport === undefined) {
        options.transport = electron_offline_net_1.makeElectronOfflineTransport;
    }
    (0, ipc_1.configureIPC)(options);
    (0, node_1.init)(options);
}
exports.init = init;
/** Sets the default integrations and ensures that multiple minidump integrations are not enabled */
function setDefaultIntegrations(defaults, options) {
    if (options.defaultIntegrations === undefined) {
        // If ElectronMinidump has been included, automatically remove SentryMinidump
        if (Array.isArray(options.integrations) && options.integrations.some((i) => i.name === 'ElectronMinidump')) {
            options.defaultIntegrations = defaults.filter((integration) => integration.name !== 'SentryMinidump');
            return;
        }
        else if (typeof options.integrations === 'function') {
            const originalFn = options.integrations;
            options.integrations = (integrations) => {
                const userIntegrations = originalFn(integrations);
                return userIntegrations.some((i) => i.name === 'ElectronMinidump')
                    ? userIntegrations.filter((integration) => integration.name !== 'SentryMinidump')
                    : userIntegrations;
            };
        }
        options.defaultIntegrations = defaults;
    }
}
//# sourceMappingURL=sdk.js.map