Object.defineProperty(exports, "__esModule", { value: true });
exports.PreloadInjection = void 0;
const core_1 = require("@sentry/core");
const utils_1 = require("@sentry/utils");
const electron_1 = require("electron");
const fs_1 = require("fs");
const path_1 = require("path");
const common_1 = require("../../common");
const electron_normalize_1 = require("../electron-normalize");
/**
 * Injects the preload script into the provided sessions.
 *
 * Defaults to injecting into the defaultSession
 */
class PreloadInjection {
    constructor() {
        /** @inheritDoc */
        this.name = PreloadInjection.id;
    }
    /** @inheritDoc */
    setupOnce() {
        var _a;
        const options = (_a = (0, core_1.getCurrentHub)().getClient()) === null || _a === void 0 ? void 0 : _a.getOptions();
        // If classic IPC mode is disabled, we shouldn't attempt to inject preload scripts
        // eslint-disable-next-line no-bitwise
        if ((options.ipcMode & common_1.IPCMode.Classic) == 0) {
            return;
        }
        electron_1.app.once('ready', () => {
            this._addPreloadToSessions(options);
        });
    }
    /**
     * Attempts to add the preload script the the provided sessions
     */
    _addPreloadToSessions(options) {
        let path = undefined;
        try {
            path = (0, electron_normalize_1.rendererRequiresCrashReporterStart)()
                ? require.resolve('../../preload/legacy.js')
                : require.resolve('../../preload/index.js');
        }
        catch (_) {
            //
        }
        if (path && typeof path === 'string' && (0, path_1.isAbsolute)(path) && (0, fs_1.existsSync)(path)) {
            for (const sesh of options.getSessions()) {
                // Fetch any existing preloads so we don't overwrite them
                const existing = sesh.getPreloads();
                sesh.setPreloads([path, ...existing]);
            }
        }
        else {
            utils_1.logger.log('The preload script could not be injected automatically. This is most likely caused by bundling of the main process');
        }
    }
}
exports.PreloadInjection = PreloadInjection;
/** @inheritDoc */
PreloadInjection.id = 'PreloadInjection';
//# sourceMappingURL=preload-injection.js.map