Object.defineProperty(exports, "__esModule", { value: true });
exports.MainContext = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@sentry/core");
const electron_1 = require("electron");
const common_1 = require("../../common");
const context_1 = require("../context");
/** Adds Electron context to events and normalises paths. */
class MainContext {
    constructor() {
        /** @inheritDoc */
        this.name = MainContext.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        var _a;
        const options = (_a = (0, core_1.getCurrentHub)().getClient()) === null || _a === void 0 ? void 0 : _a.getOptions();
        addGlobalEventProcessor((event) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const normalized = (0, common_1.normalizeEvent)(event, electron_1.app.getAppPath());
            const defaults = yield (0, context_1.getEventDefaults)(options === null || options === void 0 ? void 0 : options.release, options === null || options === void 0 ? void 0 : options.environment);
            return (0, common_1.mergeEvents)(defaults, normalized);
        }));
    }
}
exports.MainContext = MainContext;
/** @inheritDoc */
MainContext.id = 'MainContext';
//# sourceMappingURL=main-context.js.map