import { Integration } from '@sentry/types';
/**
 * Returns the minidump endpoint in Sentry
 * @param dsn Dsn
 */
export declare function minidumpUrlFromDsn(dsn: string): string;
/** Sends minidumps via the Electron built-in uploader. */
export declare class ElectronMinidump implements Integration {
    /** @inheritDoc */
    static id: string;
    /** @inheritDoc */
    name: string;
    /** Counter used to ensure no race condition when updating extra params */
    private _updateEpoch;
    private _customRelease;
    /** @inheritDoc */
    setupOnce(): void;
    /**
     * Starts the native crash reporter
     */
    private _startCrashReporter;
    /**
     * Adds a scope listener to persist changes to disk.
     */
    private _setupScopeListener;
    /** Updates Electron uploader extra params */
    private _updateExtraParams;
    /** Builds up an event to send with the native Electron uploader */
    private _getNativeUploaderEvent;
    /** Chunks up event JSON into 1 or more parameters for use with the native Electron uploader
     *
     * Returns chunks with keys and values:
     * {
     *    sentry__1: '{ json...',
     *    sentry__2: 'more json...',
     *    sentry__x: 'end json }',
     * }
     */
    private _getNativeUploaderExtraParams;
}
//# sourceMappingURL=electron-minidump.d.ts.map