import { Integration } from '@sentry/types';
import { OrBool } from '../../common/types';
import { ExitReason } from '../electron-normalize';
interface ChildProcessOptions {
    /** Child process events that generate breadcrumbs */
    breadcrumbs: Readonly<ExitReason[]>;
    /** Child process events that generate Sentry events */
    events: Readonly<ExitReason[]>;
}
/** Adds breadcrumbs for Electron events. */
export declare class ChildProcess implements Integration {
    /** @inheritDoc */
    static id: string;
    /** @inheritDoc */
    name: string;
    private readonly _options;
    /**
     * @param _options Integration options
     */
    constructor(options?: Partial<OrBool<ChildProcessOptions>>);
    /** @inheritDoc */
    setupOnce(): void;
}
export {};
//# sourceMappingURL=child-process.d.ts.map