import * as ElectronMainIntegrations from './integrations';
export type { Breadcrumb, BreadcrumbHint, Request, SdkInfo, Event, EventHint, Exception, Session, Severity, SeverityLevel, StackFrame, Stacktrace, Thread, User, } from '@sentry/types';
export { addGlobalEventProcessor, addBreadcrumb, captureException, captureEvent, captureMessage, configureScope, createTransport, getHubFromCarrier, getCurrentHub, Hub, makeMain, Scope, startTransaction, setContext, setExtra, setExtras, setTag, setTags, setUser, withScope, FunctionToString, InboundFilters, } from '@sentry/core';
export type { NodeOptions } from '@sentry/node';
export { flush, close, NodeClient, lastEventId } from '@sentry/node';
export { makeElectronTransport } from './transports/electron-net';
export { makeElectronOfflineTransport } from './transports/electron-offline-net';
export declare const Integrations: {
    Console: typeof import("@sentry/node/types/integrations").Console;
    Http: typeof import("@sentry/node/types/integrations").Http;
    OnUncaughtException: typeof import("@sentry/node/types/integrations").OnUncaughtException;
    OnUnhandledRejection: typeof import("@sentry/node/types/integrations").OnUnhandledRejection;
    LinkedErrors: typeof import("@sentry/node/types/integrations").LinkedErrors;
    Modules: typeof import("@sentry/node/types/integrations").Modules;
    ContextLines: typeof import("@sentry/node/types/integrations").ContextLines;
    Context: typeof import("@sentry/node/types/integrations").Context;
    RequestData: typeof import("@sentry/node/types/integrations").RequestData;
    LocalVariables: typeof import("@sentry/node/types/integrations").LocalVariables;
    FunctionToString: typeof import("@sentry/core").FunctionToString;
    InboundFilters: typeof import("@sentry/core").InboundFilters;
    ElectronBreadcrumbs: typeof ElectronMainIntegrations.ElectronBreadcrumbs;
    MainContext: typeof ElectronMainIntegrations.MainContext;
    SentryMinidump: typeof ElectronMainIntegrations.SentryMinidump;
    ElectronMinidump: typeof ElectronMainIntegrations.ElectronMinidump;
    PreloadInjection: typeof ElectronMainIntegrations.PreloadInjection;
    MainProcessSession: typeof ElectronMainIntegrations.MainProcessSession;
    AdditionalContext: typeof ElectronMainIntegrations.AdditionalContext;
    Net: typeof ElectronMainIntegrations.Net;
    ChildProcess: typeof ElectronMainIntegrations.ChildProcess;
    Screenshots: typeof ElectronMainIntegrations.Screenshots;
};
export type { ElectronMainOptions } from './sdk';
export { init, defaultIntegrations } from './sdk';
export { IPCMode } from '../common';
//# sourceMappingURL=index.d.ts.map