Object.defineProperty(exports, "__esModule", { value: true });
exports.removeEmptyIntegrations = exports.getIntegrations = void 0;
const utils_1 = require("@sentry/utils");
/** Return all Electron integrations and add EmptyIntegrations for integrations missing in this process. */
function getIntegrations() {
    return process.type === 'browser'
        ? Object.assign(Object.assign({}, (0, utils_1.dynamicRequire)(module, './main').Integrations), { ScopeToMain: EmptyIntegration, EventToMain: EmptyIntegration }) : Object.assign(Object.assign({}, (0, utils_1.dynamicRequire)(module, './renderer').Integrations), { SentryMinidump: EmptyIntegration, ElectronMinidump: EmptyIntegration, ElectronBreadcrumbs: EmptyIntegration, MainContext: EmptyIntegration, OnUncaughtExcept: EmptyIntegration, PreloadInjection: EmptyIntegration, MainProcessSession: EmptyIntegration, AdditionalContext: EmptyIntegration, ChildProcess: EmptyIntegration, Screenshots: EmptyIntegration });
}
exports.getIntegrations = getIntegrations;
/**
 * The EmptyIntegration gets loaded when the requested integration cannot be used in the current Electron process
 *
 * This allows you to call the same code from both Electron processes and not have to conditionally compile
 *
 * ```
 * const { init, Integrations } = require('@sentry/electron');
 *
 * init({
 *   dsn: process.env.DSN,
 *   integrations: [new Integrations.ElectronMinidump()],
 * });
 *
 */
class EmptyIntegration {
    constructor() {
        /** @inheritDoc */
        this.name = EmptyIntegration.id;
    }
    /** @inheritDoc */
    setupOnce() {
        //
    }
}
/** @inheritDoc */
EmptyIntegration.id = 'EmptyIntegration';
/** Filters out any EmptyIntegrations that are found */
function removeEmptyIntegrations(options) {
    if (Array.isArray(options.integrations)) {
        options.integrations = options.integrations.filter((i) => i.name !== EmptyIntegration.id);
    }
    else if (typeof options.integrations === 'function') {
        const originalFn = options.integrations;
        options.integrations = (integrations) => {
            const userIntegrations = originalFn(integrations);
            return userIntegrations.filter((integration) => integration.name !== EmptyIntegration.id);
        };
    }
}
exports.removeEmptyIntegrations = removeEmptyIntegrations;
//# sourceMappingURL=integrations.js.map