Object.defineProperty(exports, "__esModule", { value: true });
exports.flush = exports.close = exports.init = exports.IPCMode = exports.Integrations = exports.InboundFilters = exports.FunctionToString = exports.withScope = exports.setUser = exports.setTags = exports.setTag = exports.setExtras = exports.setExtra = exports.setContext = exports.startTransaction = exports.Scope = exports.makeMain = exports.Hub = exports.getCurrentHub = exports.getHubFromCarrier = exports.createTransport = exports.configureScope = exports.captureMessage = exports.captureEvent = exports.captureException = exports.addBreadcrumb = exports.addGlobalEventProcessor = void 0;
const tslib_1 = require("tslib");
const utils_1 = require("@sentry/utils");
const integrations_1 = require("./integrations");
var core_1 = require("@sentry/core");
Object.defineProperty(exports, "addGlobalEventProcessor", { enumerable: true, get: function () { return core_1.addGlobalEventProcessor; } });
Object.defineProperty(exports, "addBreadcrumb", { enumerable: true, get: function () { return core_1.addBreadcrumb; } });
Object.defineProperty(exports, "captureException", { enumerable: true, get: function () { return core_1.captureException; } });
Object.defineProperty(exports, "captureEvent", { enumerable: true, get: function () { return core_1.captureEvent; } });
Object.defineProperty(exports, "captureMessage", { enumerable: true, get: function () { return core_1.captureMessage; } });
Object.defineProperty(exports, "configureScope", { enumerable: true, get: function () { return core_1.configureScope; } });
Object.defineProperty(exports, "createTransport", { enumerable: true, get: function () { return core_1.createTransport; } });
Object.defineProperty(exports, "getHubFromCarrier", { enumerable: true, get: function () { return core_1.getHubFromCarrier; } });
Object.defineProperty(exports, "getCurrentHub", { enumerable: true, get: function () { return core_1.getCurrentHub; } });
Object.defineProperty(exports, "Hub", { enumerable: true, get: function () { return core_1.Hub; } });
Object.defineProperty(exports, "makeMain", { enumerable: true, get: function () { return core_1.makeMain; } });
Object.defineProperty(exports, "Scope", { enumerable: true, get: function () { return core_1.Scope; } });
Object.defineProperty(exports, "startTransaction", { enumerable: true, get: function () { return core_1.startTransaction; } });
Object.defineProperty(exports, "setContext", { enumerable: true, get: function () { return core_1.setContext; } });
Object.defineProperty(exports, "setExtra", { enumerable: true, get: function () { return core_1.setExtra; } });
Object.defineProperty(exports, "setExtras", { enumerable: true, get: function () { return core_1.setExtras; } });
Object.defineProperty(exports, "setTag", { enumerable: true, get: function () { return core_1.setTag; } });
Object.defineProperty(exports, "setTags", { enumerable: true, get: function () { return core_1.setTags; } });
Object.defineProperty(exports, "setUser", { enumerable: true, get: function () { return core_1.setUser; } });
Object.defineProperty(exports, "withScope", { enumerable: true, get: function () { return core_1.withScope; } });
Object.defineProperty(exports, "FunctionToString", { enumerable: true, get: function () { return core_1.FunctionToString; } });
Object.defineProperty(exports, "InboundFilters", { enumerable: true, get: function () { return core_1.InboundFilters; } });
exports.Integrations = (0, integrations_1.getIntegrations)();
var common_1 = require("./common");
Object.defineProperty(exports, "IPCMode", { enumerable: true, get: function () { return common_1.IPCMode; } });
/** Fetches the SDK entry point for the current process */
function getEntryPoint() {
    try {
        return process.type === 'browser' ? (0, utils_1.dynamicRequire)(module, './main') : require('./renderer');
    }
    catch (e) {
        throw new Error(`Failed to automatically detect correct SDK entry point.

In the Electron main process you should import via:
import * as Sentry from '@sentry/electron/main';

In the Electron renderer process you should import via:
import * as Sentry from '@sentry/electron/renderer';`);
    }
}
/**
 * The Sentry Electron SDK Client.
 *
 * To use this SDK, call the {@link init} function as early as possible in the
 * entry modules. This applies to the main process as well as all renderer
 * processes or further sub processes you spawn. To set context information or
 * send manual events, use the provided methods.
 *
 * @example
 * const { init } = require('@sentry/electron');
 *
 * init({
 *   dsn: '__DSN__',
 *   // ...
 * });
 *
 * @example
 * import { configureScope } from '@sentry/electron';
 * configureScope((scope: Scope) => {
 *   scope.setExtra({ battery: 0.7 });
 *   scope.setTags({ user_mode: 'admin' });
 *   scope.setUser({ id: '4711' });
 * });
 *
 * @example
 * import { addBreadcrumb } from '@sentry/electron';
 * addBreadcrumb({
 *   message: 'My Breadcrumb',
 *   // ...
 * });
 *
 * @example
 * import * as Sentry from '@sentry/electron';
 * Sentry.captureMessage('Hello, world!');
 * Sentry.captureException(new Error('Good bye'));
 * Sentry.captureEvent({
 *   message: 'Manual',
 *   stacktrace: [
 *     // ...
 *   ],
 * });
 *
 * @see ElectronOptions for documentation on configuration options.
 */
function init(options) {
    // Filter out any EmptyIntegrations
    (0, integrations_1.removeEmptyIntegrations)(options);
    getEntryPoint().init(options);
}
exports.init = init;
/**
 * Call `close()` on the current client, if there is one. See {@link Client.close}.
 *
 * @param timeout Maximum time in ms the client should wait to flush its event queue before shutting down. Omitting this
 * parameter will cause the client to wait until all events are sent before disabling itself.
 * @returns A promise which resolves to `true` if the queue successfully drains before the timeout, or `false` if it
 * doesn't (or if there's no client defined).
 */
function close(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const entryPoint = getEntryPoint();
        if (entryPoint.close) {
            return entryPoint.close(timeout);
        }
        throw new Error('The Electron SDK should be closed from the main process');
    });
}
exports.close = close;
/**
 * Call `flush()` on the current client, if there is one. See {@link Client.flush}.
 *
 * @param timeout Maximum time in ms the client should wait to flush its event queue. Omitting this parameter will cause
 * the client to wait until all events are sent before resolving the promise.
 * @returns A promise which resolves to `true` if the queue successfully drains before the timeout, or `false` if it
 * doesn't (or if there's no client defined).
 */
function flush(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const entryPoint = getEntryPoint();
        if (entryPoint.flush) {
            return entryPoint.flush(timeout);
        }
        throw new Error('The Electron SDK should be flushed from the main process');
    });
}
exports.flush = flush;
//# sourceMappingURL=index.js.map