import { chromeStackLineParser } from '@sentry/browser';
import { dropUndefinedKeys, nodeStackLineParser, stripSentryFramesAndReverse } from '@sentry/utils';
const [, chrome] = chromeStackLineParser;
const [, node] = nodeStackLineParser();
/**
 * A stack parser than combines Chrome and node.js parsers to give the best results even when nodeIntegration = true
 */
export const electronRendererStackParser = (stack, skipFirst = 0) => {
    const frames = [];
    for (const line of stack.split('\n').slice(skipFirst)) {
        const chromeFrame = chrome(line);
        const nodeFrame = node(line);
        // We favour the chrome parser unless in_app == false
        if (chromeFrame && (nodeFrame === null || nodeFrame === void 0 ? void 0 : nodeFrame.in_app) !== false) {
            frames.push(chromeFrame);
        }
        else if (nodeFrame) {
            frames.push(dropUndefinedKeys(nodeFrame));
        }
    }
    return stripSentryFramesAndReverse(frames);
};
//# sourceMappingURL=stack-parse.js.map