import { normalize } from '@sentry/utils';
import { getIPC } from '../ipc';
/**
 * Passes events to the main process.
 */
export class EventToMain {
    constructor() {
        /** @inheritDoc */
        this.name = EventToMain.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        const ipc = getIPC();
        addGlobalEventProcessor((event) => {
            // Ensure breadcrumbs is not `undefined` as `walk` translates it into a string
            event.breadcrumbs = event.breadcrumbs || [];
            // Remove the environment as it defaults to 'production' and overwrites the main process environment
            delete event.environment;
            ipc.sendEvent(JSON.stringify(normalize(event, 20, 2000)));
            // Events are handled and sent from the main process so we return null here so nothing is sent from the renderer
            return null;
        });
    }
}
/** @inheritDoc */
EventToMain.id = 'EventToMain';
//# sourceMappingURL=event-to-main.js.map