import { contextBridge, crashReporter, ipcRenderer } from 'electron';
import * as electron from 'electron';
var PROTOCOL_SCHEME = 'sentry-ipc';
var IPCChannel;
(function (IPCChannel) {
    IPCChannel["PING"] = "sentry-electron.ping";
    IPCChannel["EVENT"] = "sentry-electron.event";
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
})(IPCChannel || (IPCChannel = {}));
;
if (window.__SENTRY_IPC__) {
    console.log('Sentry Electron preload has already been run');
}
else {
    crashReporter.start({
        companyName: '',
        ignoreSystemCrashHandler: true,
        productName: electron.remote.app.name || electron.remote.app.getName(),
        submitURL: '',
        uploadToServer: false,
    });
    var ipcObject = {
        sendScope: function (scopeJson) { return ipcRenderer.send(IPCChannel.SCOPE, scopeJson); },
        sendEvent: function (eventJson) { return ipcRenderer.send(IPCChannel.EVENT, eventJson); },
        sendEnvelope: function (envelope) { return ipcRenderer.send(IPCChannel.ENVELOPE, envelope); },
    };
    window.__SENTRY_IPC__ = ipcObject;
    if (contextBridge) {
        try {
            contextBridge.exposeInMainWorld('__SENTRY_IPC__', ipcObject);
        }
        catch (e) {
        }
    }
}
