import { IPCMode } from '../common';
import { NodeOptions } from '@sentry/node';
import { Integration, Options } from '@sentry/types';
import { Session, WebContents } from 'electron';
import { ElectronOfflineTransportOptions } from './transports/electron-offline-net';
export declare const defaultIntegrations: Integration[];
export interface ElectronMainOptionsInternal extends Options<ElectronOfflineTransportOptions> {
    /**
     * Inter-process communication mode to receive event and scope from renderers
     *
     * IPCMode.Classic - Configures Electron IPC
     * IPCMode.Protocol - Configures a custom protocol
     * IPCMode.Both - Configures both IPC and custom protocol
     *
     * defaults to IPCMode.Both for maximum compatibility
     */
    ipcMode: IPCMode;
    /**
     * A function that returns an array of Electron session objects
     *
     * These sessions are used to configure communication between the Electron
     * main and renderer processes.
     *
     * Defaults to () => [session.defaultSession]
     */
    getSessions: () => Session[];
    /**
     * Callback to allow custom naming of renderer processes.
     *
     * If the callback is not set, or it returns `undefined`, the default naming
     * scheme is used.
     */
    getRendererName?: (contents: WebContents) => string | undefined;
    /**
     * Screenshots may contain PII and is an opt-in feature
     *
     * If set to true, screenshots will be captured and included with all JavaScript events.
     * Screenshots are not included for native crashes since it's not possible to capture images of crashed Electron
     * renderers.
     */
    attachScreenshot?: boolean;
}
export type ElectronMainOptions = Pick<Partial<ElectronMainOptionsInternal>, 'getSessions' | 'ipcMode'> & Omit<ElectronMainOptionsInternal, 'getSessions' | 'ipcMode'> & NodeOptions;
/**
 * Initialize Sentry in the Electron main process
 */
export declare function init(userOptions: ElectronMainOptions): void;
//# sourceMappingURL=sdk.d.ts.map