import { Integration } from '@sentry/types';
import { OrBool, OrFalse } from '../../common/types';
type ShouldTraceFn = (method: string, url: string) => boolean;
interface NetOptions {
    /**
     * Whether breadcrumbs should be captured for net requests
     *
     * Defaults to: true
     */
    breadcrumbs: boolean;
    /**
     * Whether to capture transaction spans for net requests
     *
     * true | false | (method: string, url: string) => boolean
     * Defaults to: true
     */
    tracing: ShouldTraceFn;
    /**
     * Whether to add 'sentry-trace' headers to outgoing requests
     *
     * true | false | (method: string, url: string) => boolean
     * Defaults to: true
     */
    tracingOrigins: ShouldTraceFn;
}
/** Converts all user supplied options to T | false */
export declare function normalizeOptions(options: Partial<OrBool<NetOptions>>): Partial<OrFalse<NetOptions>>;
/** http module integration */
export declare class Net implements Integration {
    /** @inheritDoc */
    static id: string;
    /** @inheritDoc */
    name: string;
    private readonly _options;
    /** @inheritDoc */
    constructor(options?: Partial<OrBool<NetOptions>>);
    /** @inheritDoc */
    setupOnce(): void;
}
export {};
//# sourceMappingURL=net-breadcrumbs.d.ts.map