import { Integration } from '@sentry/types';
/** A function that returns true if the named event should create breadcrumbs */
type EventFunction = (name: string) => boolean;
type EventTypes = boolean | string[] | EventFunction | undefined;
interface ElectronBreadcrumbsOptions<T> {
    /**
     * app events
     *
     * default: (name) => !name.startsWith('remote-')
     */
    app: T;
    /**
     * autoUpdater events
     *
     * default: all
     */
    autoUpdater: T;
    /**
     * webContents events
     * default: ['dom-ready', 'context-menu', 'load-url', 'destroyed']
     */
    webContents: T;
    /**
     * BrowserWindow events
     *
     * default: ['closed', 'close', 'unresponsive', 'responsive', 'show', 'blur', 'focus', 'hide',
     *            'maximize', 'minimize', 'restore', 'enter-full-screen', 'leave-full-screen' ]
     */
    browserWindow: T;
    /**
     * screen events
     *
     * default: all
     */
    screen: T;
    /**
     * powerMonitor events
     *
     * default: all
     */
    powerMonitor: T;
    /**
     * Whether to capture window titles with webContents/browserWindow breadcrumbs
     *
     * default: false
     */
    captureWindowTitles: boolean;
}
/** Converts all user supplied options to function | false */
export declare function normalizeOptions(options: Partial<ElectronBreadcrumbsOptions<EventTypes>>): Partial<ElectronBreadcrumbsOptions<EventFunction | false>>;
/** Adds breadcrumbs for Electron events. */
export declare class ElectronBreadcrumbs implements Integration {
    /** @inheritDoc */
    static id: string;
    /** @inheritDoc */
    name: string;
    private readonly _options;
    /**
     * @param _options Integration options
     */
    constructor(options?: Partial<ElectronBreadcrumbsOptions<EventTypes>>);
    /** @inheritDoc */
    setupOnce(): void;
    /**
     * Monkey patches the EventEmitter to capture breadcrumbs for the specified events. 🙈
     */
    private _patchEventEmitter;
}
export {};
//# sourceMappingURL=electron-breadcrumbs.d.ts.map