import { EventProcessor, Integration } from '@sentry/types';
export interface AdditionalContextOptions {
    cpu: boolean;
    screen: boolean;
    memory: boolean;
    language: boolean;
}
/** Adds Electron context to events and normalises paths. */
export declare class AdditionalContext implements Integration {
    /** @inheritDoc */
    static id: string;
    /** @inheritDoc */
    name: string;
    private readonly _options;
    private _lazyDeviceContext;
    constructor(options?: Partial<AdditionalContextOptions>);
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor: (callback: EventProcessor) => void): void;
    /** Adds additional context to event */
    private _addAdditionalContext;
    /** Sets the display info */
    private _setPrimaryDisplayInfo;
}
//# sourceMappingURL=additional-context.d.ts.map