import { __awaiter } from "tslib";
import { app } from 'electron';
import { mkdir, readdir, readFile, rename, stat, statSync, unlink, writeFile } from 'fs';
import { dirname, join, resolve } from 'path';
import { promisify } from 'util';
export const sentryCachePath = join(app.getPath('userData'), 'sentry');
export const writeFileAsync = promisify(writeFile);
export const readFileAsync = promisify(readFile);
export const mkdirAsync = promisify(mkdir);
export const statAsync = promisify(stat);
export const unlinkAsync = promisify(unlink);
export const readDirAsync = promisify(readdir);
export const renameAsync = promisify(rename);
// mkdir with recursive was only added in Node 10+
/**
 * Recursively creates the given path.
 *
 * @param path A relative or absolute path to create.
 * @returns A Promise that resolves when the path has been created.
 */
export function mkdirp(path) {
    return __awaiter(this, void 0, void 0, function* () {
        // eslint-disable-next-line no-bitwise
        const realPath = resolve(path);
        try {
            yield mkdirAsync(realPath, 0o777);
        }
        catch (err) {
            const error = err;
            if (error && error.code === 'ENOENT') {
                yield mkdirp(dirname(realPath));
                yield mkdirAsync(realPath, 0o777);
            }
            try {
                if (!statSync(realPath).isDirectory()) {
                    throw err;
                }
            }
            catch (_) {
                throw err;
            }
        }
    });
}
//# sourceMappingURL=fs.js.map