import { Envelope, Event } from '@sentry/types';
/**
 * Normalizes URLs in exceptions and stacktraces so Sentry can fingerprint
 * across platforms.
 *
 * @param url The URL to be normalized.
 * @param basePath The application base path.
 * @returns The normalized URL.
 */
export declare function normalizeUrl(url: string, basePath: string): string;
/**
 * Normalizes all URLs in an event. See {@link normalizeUrl} for more
 * information. Mutates the passed in event.
 *
 * @param event The event to normalize.
 */
export declare function normalizeEvent(event: Event, basePath: string): Event;
/** Normalizes URLs in any replay_event items found in an envelope */
export declare function normalizeUrlsInReplayEnvelope(envelope: Envelope, basePath: string): Envelope;
//# sourceMappingURL=normalize.d.ts.map