Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeEvents = void 0;
const tslib_1 = require("tslib");
const deepmerge_1 = tslib_1.__importDefault(require("deepmerge"));
/** Removes private properties from event before merging */
function removePrivateProperties(event) {
    for (const span of event.spans || []) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        delete span.spanRecorder;
        delete span.transaction;
    }
}
/** Merges Events with defaults */
function mergeEvents(defaults, event) {
    removePrivateProperties(event);
    const newEvent = (0, deepmerge_1.default)(defaults, event);
    // We need to copy spans across manually
    //
    // Spans contain a custom toJSON function for serialization and without
    // this they are serialised with camelCase properties rather than the
    // snake_case required by the Sentry API.
    if (event.spans || defaults.spans) {
        newEvent.spans = event.spans || defaults.spans;
    }
    // We don't want packages array in sdk to get merged with duplicates
    return Object.assign(Object.assign({}, newEvent), { sdk: Object.assign(Object.assign({}, defaults.sdk), event.sdk) });
}
exports.mergeEvents = mergeEvents;
//# sourceMappingURL=merge.js.map