import type { Attachment, AttachmentItem, DataCategory, DsnComponents, Envelope, EnvelopeItemType, Event, EventEnvelopeHeaders, SdkInfo, SdkMetadata, TextEncoderInternal } from '@sentry/types';
/**
 * Creates an envelope.
 * Make sure to always explicitly provide the generic to this function
 * so that the envelope types resolve correctly.
 */
export declare function createEnvelope<E extends Envelope>(headers: E[0], items?: E[1]): E;
/**
 * Add an item to an envelope.
 * Make sure to always explicitly provide the generic to this function
 * so that the envelope types resolve correctly.
 */
export declare function addItemToEnvelope<E extends Envelope>(envelope: E, newItem: E[1][number]): E;
/**
 * Convenience function to loop through the items and item types of an envelope.
 * (This function was mostly created because working with envelope types is painful at the moment)
 */
export declare function forEachEnvelopeItem<E extends Envelope>(envelope: Envelope, callback: (envelopeItem: E[1][number], envelopeItemType: E[1][number][0]['type']) => void): void;
/**
 * Serializes an envelope.
 */
export declare function serializeEnvelope(envelope: Envelope, textEncoder?: TextEncoderInternal): string | Uint8Array;
interface TextDecoderInternal {
    decode(input?: Uint8Array): string;
}
/**
 * Parses an envelope
 */
export declare function parseEnvelope(env: string | Uint8Array, textEncoder: TextEncoderInternal, textDecoder: TextDecoderInternal): Envelope;
/**
 * Creates attachment envelope items
 */
export declare function createAttachmentEnvelopeItem(attachment: Attachment, textEncoder?: TextEncoderInternal): AttachmentItem;
/**
 * Maps the type of an envelope item to a data category.
 */
export declare function envelopeItemTypeToDataCategory(type: EnvelopeItemType): DataCategory;
/** Extracts the minimal SDK info from from the metadata or an events */
export declare function getSdkMetadataForEnvelopeHeader(metadataOrEvent?: SdkMetadata | Event): SdkInfo | undefined;
/**
 * Creates event envelope headers, based on event, sdk info and tunnel
 * Note: This function was extracted from the core package to make it available in Replay
 */
export declare function createEventEnvelopeHeaders(event: Event, sdkInfo: SdkInfo | undefined, tunnel: string | undefined, dsn: DsnComponents): EventEnvelopeHeaders;
export {};
//# sourceMappingURL=envelope.d.ts.map