export type MDJSNodeProperties = {
    value: string;
    lang: 'js' | 'ts' | 'html';
    meta: 'script' | 'story' | 'preview-story';
};
export type MDJSNode = UnistNode & MDJSNodeProperties;
export type Story = import('../types/code.js').Story;
export type StoryTypes = import('../types/code.js').StoryTypes;
export type TagFunction = (name: string) => string;
export type UnistNode = import('unist').Node;
export type UnistParent = import('unist').Parent;
export type VFileOptions = import('vfile').VFileOptions;
/**
 * @param {object} arg
 * @param {TagFunction} [arg.storyTag]
 * @param {TagFunction} [arg.previewStoryTag]
 * @param {number} [arg.counter]
 */
export function mdjsStoryParse({ storyTag, previewStoryTag, }?: {
    storyTag?: TagFunction | undefined;
    previewStoryTag?: TagFunction | undefined;
    counter?: number | undefined;
}): (tree: Node, file: VFileOptions) => Promise<Node>;
//# sourceMappingURL=mdjsStoryParse.d.ts.map