export type VFileOptions = import('vfile').VFileOptions;
export type Node = import('unist').Node;
export type Story = import('../types/code.js').Story;
export type simulationSettings = {
    simulatorUrl?: string | undefined;
};
export type rocketConfig = {
    pathPrefix?: string | undefined;
};
/** @typedef {import('vfile').VFileOptions} VFileOptions */
/** @typedef {import('unist').Node} Node */
/** @typedef {import('../types/code.js').Story} Story */
/**
 * @typedef {Object} simulationSettings
 * @property {string} [simulatorUrl]
 */
/**
 * @typedef {Object} rocketConfig
 * @property {string} [pathPrefix]
 */
/**
 * @param {object} options
 * @param {string} [options.rootNodeQueryCode]
 * @param {simulationSettings} [options.simulationSettings]
 * @param {rocketConfig} [options.rocketConfig]
 * @returns
 */
export function mdjsSetupCode({ rootNodeQueryCode, simulationSettings, rocketConfig, }?: {
    rootNodeQueryCode?: string | undefined;
    simulationSettings?: simulationSettings | undefined;
    rocketConfig?: rocketConfig | undefined;
}): (tree: Node, file: VFileOptions) => Promise<import("unist").Node>;
//# sourceMappingURL=mdjsSetupCode.d.ts.map