export type Story = import('../types/code').Story;
export type ParseResult = import('../types/code').ParseResult;
export type ProcessResult = import('../types/code').ProcessResult;
export type MdjsProcessPlugin = import('../types/code').MdjsProcessPlugin;
/**
 * Processes mdjs to html/js/stories
 *
 * Js code includes the linking between js and stories
 *
 * @param {string} mdjs
 * @param {object} options
 * @param {string} [options.rootNodeQueryCode]
 * @param {function[]} [options.setupUnifiedPlugins]
 * @param {MdjsProcessPlugin[]} [options.plugins] deprecated option use setupUnifiedPlugins instead
 */
export function mdjsProcess(mdjs: string, { setupUnifiedPlugins }?: {
    rootNodeQueryCode?: string | undefined;
    setupUnifiedPlugins?: Function[] | undefined;
    plugins?: import("plugins-manager/dist-types/types/main").MetaPlugin<unified.Plugin<[(unified.Settings | undefined)?], unified.Settings>>[] | undefined;
}): Promise<{
    stories: import("../types/code").Story[];
    jsCode: string;
    html: string;
}>;
import unified = require("unified");
//# sourceMappingURL=mdjsProcess.d.ts.map