/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import '@material/mwc-ripple/mwc-ripple';
import { AriaHasPopup } from '@material/mwc-base/aria-property';
import { Ripple } from '@material/mwc-ripple/mwc-ripple';
import { RippleHandlers } from '@material/mwc-ripple/ripple-handlers';
import { LitElement, TemplateResult } from 'lit';
/** @soyCompatible */
export declare class IconButtonBase extends LitElement {
    disabled: boolean;
    icon: string;
    /** @soyPrefixAttribute */
    ariaLabel: string;
    /** @soyPrefixAttribute */
    ariaHasPopup: AriaHasPopup;
    buttonElement: HTMLElement;
    ripple: Promise<Ripple | null>;
    protected shouldRenderRipple: boolean;
    protected rippleHandlers: RippleHandlers;
    /** @soyTemplate */
    protected renderRipple(): TemplateResult | string;
    focus(): void;
    blur(): void;
    /** @soyTemplate */
    protected render(): TemplateResult;
    protected handleRippleMouseDown(event?: Event): void;
    protected handleRippleTouchStart(event?: Event): void;
    protected handleRippleDeactivate(): void;
    protected handleRippleMouseEnter(): void;
    protected handleRippleMouseLeave(): void;
    protected handleRippleFocus(): void;
    protected handleRippleBlur(): void;
}
