/**
 * @typedef {import('lit').ReactiveControllerHost} ReactiveControllerHost
 * @typedef {import('lit').ReactiveController} ReactiveController
 * @implements {ReactiveController}
 */
export class ScopedStylesController implements ReactiveController {
    /**
     * @param {import('lit').CSSResult} scope
     * @return {import('lit').CSSResultGroup}
     */
    static scopedStyles(scope: import('lit').CSSResult): import('lit').CSSResultGroup;
    /**
     * @param {ReactiveControllerHost & import('lit').LitElement} host
     */
    constructor(host: ReactiveControllerHost & import('lit').LitElement);
    host: import("lit").ReactiveControllerHost & import("lit").LitElement;
    __styleTag: HTMLStyleElement;
    scopedClass: string;
    hostConnected(): void;
    hostDisconnected(): void;
    __setupStyleTag(): void;
    __teardownStyleTag(): void;
}
export type ReactiveControllerHost = import('lit').ReactiveControllerHost;
export type ReactiveController = import('lit').ReactiveController;
