/**
 * # <lion-accordion> webcomponent
 *
 * @customElement lion-accordion
 * @extends LitElement
 */
export class LionAccordion extends LitElement {
    static get properties(): {
        /**
         * index number of the focused accordion
         */
        focusedIndex: {
            type: NumberConstructor;
        };
        /**
         * array of indices of the expanded accordions
         */
        expanded: {
            type: ArrayConstructor;
        };
    };
    static get styles(): import("@lion/core").CSSResult[];
    /**
     * @param {number} value
     */
    set focusedIndex(arg: number);
    get focusedIndex(): number;
    __focusedIndex: number;
    /**
     * @param {number[]} value
     */
    set expanded(arg: number[]);
    get expanded(): number[];
    __expanded: number[];
    styles: {};
    /**
     * @type {StoreEntry[]}
     * @private
     */
    private __store;
    /**
     *  @private
     */
    private __setupSlots;
    /**
     *  @private
     */
    private __setupStore;
    /**
     * @param {number} index
     * @private
     */
    private __createInvokerClickHandler;
    /**
     * @param {Event} e
     * @private
     */
    private __handleInvokerKeydown;
    /**
     *  @private
     */
    private get _pairCount();
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _setupContent(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _setupInvoker(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _cleanInvoker(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _focusInvoker(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _unfocusInvoker(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _collapse(entry: StoreEntry): void;
    /**
     * @param {StoreEntry} entry
     * @protected
     */
    protected _expand(entry: StoreEntry): void;
    /**
     *  @private
     */
    private __updateFocused;
    /**
     *  @private
     */
    private __updateExpanded;
    /**
     * @param {number} value
     * @private
     */
    private __toggleExpanded;
    /**
     *  @private
     */
    private __cleanStore;
}
export type StoreEntry = {
    /**
     * Unique ID for the entry
     */
    uid: string;
    /**
     * index of the node
     */
    index: number;
    /**
     * invoker node
     */
    invoker: HTMLElement;
    /**
     * content node
     */
    content: HTMLElement;
    /**
     * executed on click event
     */
    clickHandler: (event: Event) => unknown;
    /**
     * executed on keydown event
     */
    keydownHandler: (event: Event) => unknown;
};
import { LitElement } from "@lion/core";
