# How to contribute

Great! Osmdroid continues to improve from the contributions of its users. This could include code 
contributions, sample fragments for [OpenStreetMapViewer](https://github.com/osmdroid/osmdroid/tree/master/OpenStreetMapViewer),
or [wiki content](https://github.com/osmdroid/osmdroid/wiki). There's a lot in the wiki so please
have a look there.

# Creating an issue

There are several reasons to create a new issue. As always, make sure you search through open and **closed** 
issues before opening a new one. Repeat. Please search through open and **closed** issues before
opening a new one. Also search the [wiki](https://github.com/osmdroid/osmdroid/wiki) and [stack overflow](http://stackoverflow.com/questions/tagged/osmdroid).
There's a good chance that whatever you're looking for has been answer already.

## New ideas, enhancements and feature requests

Great we love new ideas and welcome opportunities for improvement.

### I'm not a developer

Great. Feel free to open a new issue. Please describe the enhancement or feature you like and then 
be patient. We are volunteers and don't get paid to work on osmdroid.

The wiki is also open for anyone to edit, but it's not monitored for questions for feature requests.

### I'm a developer

Fantastic. It's very rare for us to deny pull requests. Open a ticket to let other's know what you 
are working on along with a description. Fork osmdroid/master, then create a branch using the 
following naming scheme:

 * Bugs: use `bug/#(issueNumber)
 * Features: use `feature/#issueNumber)

See the [Developer 
Guidelines](https://github.com/osmdroid/osmdroid/wiki/Developer-Guidelines) page for code 
contributions before opening a pull request.

Please refrain from reformatting or rearranging the code. It makes it very hard to identify changes
in pull requests. We periodically will reformat the whole source base but please don't do before PRs.

If you're adding a new feature or function, please either incorporate a test or a sample that shows
how your new function can be used. Oh, and please make sure it works ;)

## Questions and HowTo's

If it's not covered already, you can try the [osmdroid google group](https://groups.google.com/forum/#!forum/osmdroid)
or post on [stack overflow](http://stackoverflow.com/questions/tagged/osmdroid).

## Bug Reports

Sorry to hear about your troubles. First of all, search for existing issues (open and closed). It
was probably covered once before. There's also [old issues](https://code.google.com/archive/p/osmdroid/issues)
at the old google code site.
 
Next, please make sure that the problem you can ran into isn't already covered by the sample 
application. There's tons of examples and bug drivers that are meant to reproduce issues or 
demonstrate how to perform basic tasks with osmdroid. It's on the play store and it's available for 
download in the release section of GitHub. No excuses.

So if it's a new issue. Please include the following:

 * Steps to reproduce and/or sample code to recreate the problem.
 * We'll also need to know what version of osmdroid you're using
 * The version of Android in the device in question (or API level)
 * Sometimes the manufacture is helpful too, since there can be variants of Android that may affect 
   things (such as x86).

Finally, please be patient. We are volunteers and don't get paid to work on osmdroid. If you are a
developer, fork osmdroid and fix it yourself. 
