/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.RootInputStream;
import org.apache.james.mime4j.parser.AbstractEntity;
import org.apache.james.mime4j.parser.EntityStateMachine;
import org.apache.james.mime4j.parser.EntityStates;
import org.apache.james.mime4j.parser.MimeEntity;
import org.apache.james.mime4j.parser.RawEntity;
import org.apache.james.mime4j.parser.RecursionMode;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeTokenStream
implements EntityStates,
RecursionMode {
    private final boolean strictParsing;
    private final boolean maximalBodyDescriptor;
    private final LinkedList entities = new LinkedList();
    private int state = -1;
    private EntityStateMachine currentStateMachine;
    private int recursionMode = 0;
    private BufferedLineReaderInputStream inbuffer;
    private RootInputStream rootInputStream;

    public static final MimeTokenStream createMaximalDescriptorStream() {
        return new MimeTokenStream(false, true);
    }

    public static final MimeTokenStream createStrictValidationStream() {
        return new MimeTokenStream(true, false);
    }

    public MimeTokenStream() {
        this(false, false);
    }

    protected MimeTokenStream(boolean strictParsing, boolean maximalBodyDescriptor) {
        this.strictParsing = strictParsing;
        this.maximalBodyDescriptor = maximalBodyDescriptor;
    }

    public void parse(InputStream stream) {
        this.doParse(stream, null);
    }

    public void parseHeadless(InputStream stream, String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Content type may not be null");
        }
        this.doParse(stream, contentType);
    }

    private void doParse(InputStream stream, String contentType) {
        this.entities.clear();
        this.rootInputStream = new RootInputStream(stream);
        this.inbuffer = new BufferedLineReaderInputStream(this.rootInputStream, 4096);
        switch (this.recursionMode) {
            case 2: {
                RawEntity rawentity = new RawEntity(this.inbuffer);
                this.currentStateMachine = rawentity;
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                MimeEntity mimeentity = new MimeEntity(this.rootInputStream, this.inbuffer, null, 0, 1, this.maximalBodyDescriptor, this.strictParsing);
                mimeentity.setRecursionMode(this.recursionMode);
                if (contentType != null) {
                    mimeentity.skipHeader(contentType);
                }
                this.currentStateMachine = mimeentity;
            }
        }
        this.entities.add(this.currentStateMachine);
        this.state = this.currentStateMachine.getState();
    }

    public boolean isRaw() {
        return this.recursionMode == 2;
    }

    public int getRecursionMode() {
        return this.recursionMode;
    }

    public void setRecursionMode(int mode) {
        this.recursionMode = mode;
        if (this.currentStateMachine != null) {
            this.currentStateMachine.setRecursionMode(mode);
        }
    }

    public void stop() {
        this.inbuffer.clear();
        this.rootInputStream.truncate();
    }

    public int getState() {
        return this.state;
    }

    public InputStream getInputStream() {
        return this.currentStateMachine.getContentStream();
    }

    public InputStream getDecodedInputStream() {
        BodyDescriptor bodyDescriptor = this.getBodyDescriptor();
        String transferEncoding = bodyDescriptor.getTransferEncoding();
        InputStream dataStream = this.currentStateMachine.getContentStream();
        if (MimeUtil.isBase64Encoding(transferEncoding)) {
            dataStream = new Base64InputStream(dataStream);
        } else if (MimeUtil.isQuotedPrintableEncoded(transferEncoding)) {
            dataStream = new QuotedPrintableInputStream(dataStream);
        }
        return dataStream;
    }

    public Reader getReader() {
        BodyDescriptor bodyDescriptor = this.getBodyDescriptor();
        String mimeCharset = bodyDescriptor.getCharset();
        Charset charset = mimeCharset == null || "".equals(mimeCharset) ? Charset.forName("US-ASCII") : Charset.forName(mimeCharset);
        InputStream instream = this.getDecodedInputStream();
        return new InputStreamReader(instream, charset);
    }

    public BodyDescriptor getBodyDescriptor() {
        return this.currentStateMachine.getBodyDescriptor();
    }

    public String getField() {
        return this.currentStateMachine.getField();
    }

    public String getFieldName() {
        return this.currentStateMachine.getFieldName();
    }

    public String getFieldValue() {
        return this.currentStateMachine.getFieldValue();
    }

    public int next() throws IOException, MimeException {
        if (this.state == -1 || this.currentStateMachine == null) {
            throw new IllegalStateException("No more tokens are available.");
        }
        while (this.currentStateMachine != null) {
            EntityStateMachine next = this.currentStateMachine.advance();
            if (next != null) {
                this.entities.add(next);
                this.currentStateMachine = next;
            }
            this.state = this.currentStateMachine.getState();
            if (this.state != -1) {
                return this.state;
            }
            this.entities.removeLast();
            if (this.entities.isEmpty()) {
                this.currentStateMachine = null;
                continue;
            }
            this.currentStateMachine = (EntityStateMachine)this.entities.getLast();
            this.currentStateMachine.setRecursionMode(this.recursionMode);
        }
        this.state = -1;
        return this.state;
    }

    public static final String stateToString(int state) {
        return AbstractEntity.stateToString(state);
    }
}

