/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.field.DefaultFieldParser;

public abstract class Field {
    public static final String SENDER = "Sender";
    public static final String FROM = "From";
    public static final String TO = "To";
    public static final String CC = "Cc";
    public static final String BCC = "Bcc";
    public static final String REPLY_TO = "Reply-To";
    public static final String RESENT_SENDER = "Resent-Sender";
    public static final String RESENT_FROM = "Resent-From";
    public static final String RESENT_TO = "Resent-To";
    public static final String RESENT_CC = "Resent-Cc";
    public static final String RESENT_BCC = "Resent-Bcc";
    public static final String DATE = "Date";
    public static final String RESENT_DATE = "Resent-Date";
    public static final String SUBJECT = "Subject";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String FIELD_NAME_PATTERN = "^([\\x21-\\x39\\x3b-\\x7e]+)[ \t]*:";
    private static final Pattern fieldNamePattern = Pattern.compile("^([\\x21-\\x39\\x3b-\\x7e]+)[ \t]*:");
    private static final DefaultFieldParser parser = new DefaultFieldParser();
    private final String name;
    private final String body;
    private final String raw;

    protected Field(String name, String body, String raw) {
        this.name = name;
        this.body = body;
        this.raw = raw;
    }

    public static Field parse(String raw) {
        String unfolded = raw.replaceAll("\r|\n", "");
        Matcher fieldMatcher = fieldNamePattern.matcher(unfolded);
        if (!fieldMatcher.find()) {
            throw new IllegalArgumentException("Invalid field in string");
        }
        String name = fieldMatcher.group(1);
        String body = unfolded.substring(fieldMatcher.end());
        if (body.length() > 0 && body.charAt(0) == ' ') {
            body = body.substring(1);
        }
        return parser.parse(name, body, raw);
    }

    public static DefaultFieldParser getParser() {
        return parser;
    }

    public String getName() {
        return this.name;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isContentType() {
        return CONTENT_TYPE.equalsIgnoreCase(this.name);
    }

    public boolean isSubject() {
        return SUBJECT.equalsIgnoreCase(this.name);
    }

    public boolean isFrom() {
        return FROM.equalsIgnoreCase(this.name);
    }

    public boolean isTo() {
        return TO.equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.raw;
    }
}

