package org.nsh07.wikireader.ui.settingsScreen

import androidx.compose.animation.core.animateDpAsState
import androidx.compose.foundation.clickable
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.interaction.collectIsPressedAsState
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.ExperimentalMaterial3ExpressiveApi
import androidx.compose.material3.ListItem
import androidx.compose.material3.ListItemColors
import androidx.compose.material3.ListItemDefaults
import androidx.compose.material3.MaterialTheme.motionScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.coerceAtLeast
import androidx.compose.ui.unit.dp

@OptIn(ExperimentalMaterial3ExpressiveApi::class)
@Composable
fun ClickableListItem(
    headlineContent: @Composable (() -> Unit),
    modifier: Modifier = Modifier,
    overlineContent: @Composable (() -> Unit)? = null,
    supportingContent: @Composable (() -> Unit)? = null,
    leadingContent: @Composable (() -> Unit)? = null,
    trailingContent: @Composable (() -> Unit)? = null,
    colors: ListItemColors = ListItemDefaults.colors(),
    tonalElevation: Dp = ListItemDefaults.Elevation,
    shadowElevation: Dp = ListItemDefaults.Elevation,
    items: Int,
    index: Int,
    onClick: () -> Unit
) {
    val interactionSource = remember { MutableInteractionSource() }
    val isPressed by interactionSource.collectIsPressedAsState()

    val top by animateDpAsState(
        if (isPressed) 40.dp
        else {
            if (items == 1 || index == 0) 20.dp
            else 4.dp
        },
        motionScheme.fastSpatialSpec()
    )
    val bottom by animateDpAsState(
        if (isPressed) 40.dp
        else {
            if (items == 1 || index == items - 1) 20.dp
            else 4.dp
        },
        motionScheme.fastSpatialSpec()
    )

    ListItem(
        headlineContent = headlineContent,
        modifier = modifier
            .clip(
                RoundedCornerShape(
                    topStart = top.coerceAtLeast(0.dp),
                    topEnd = top.coerceAtLeast(0.dp),
                    bottomStart = bottom.coerceAtLeast(0.dp),
                    bottomEnd = bottom.coerceAtLeast(0.dp)
                )
            )
            .clickable(
                onClick = onClick,
                interactionSource = interactionSource,
            ),
        overlineContent = overlineContent,
        supportingContent = supportingContent,
        leadingContent = leadingContent,
        trailingContent = trailingContent,
        colors = colors,
        tonalElevation = tonalElevation,
        shadowElevation = shadowElevation
    )
}