/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.acra.CrashReportDialog;
import org.acra.HttpUtils;
import org.acra.ReportingInteractionMode;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private static final String LOG_TAG = "ACRA";
    private static final int MAX_SEND_REPORTS = 5;
    private static final String VERSION_NAME_KEY = "entry.0.single";
    private static final String PACKAGE_NAME_KEY = "entry.1.single";
    private static final String FILE_PATH_KEY = "entry.2.single";
    private static final String PHONE_MODEL_KEY = "entry.3.single";
    private static final String ANDROID_VERSION_KEY = "entry.4.single";
    private static final String BOARD_KEY = "entry.5.single";
    private static final String BRAND_KEY = "entry.6.single";
    private static final String DEVICE_KEY = "entry.7.single";
    private static final String DISPLAY_KEY = "entry.8.single";
    private static final String FINGERPRINT_KEY = "entry.9.single";
    private static final String HOST_KEY = "entry.10.single";
    private static final String ID_KEY = "entry.11.single";
    private static final String MODEL_KEY = "entry.12.single";
    private static final String PRODUCT_KEY = "entry.13.single";
    private static final String TAGS_KEY = "entry.14.single";
    private static final String TIME_KEY = "entry.15.single";
    private static final String TYPE_KEY = "entry.16.single";
    private static final String USER_KEY = "entry.17.single";
    private static final String TOTAL_MEM_SIZE_KEY = "entry.18.single";
    private static final String AVAILABLE_MEM_SIZE_KEY = "entry.19.single";
    private static final String CUSTOM_DATA_KEY = "entry.20.single";
    private static final String STACK_TRACE_KEY = "entry.21.single";
    private Properties mCrashProperties = new Properties();
    Map<String, String> mCustomParameters = new HashMap<String, String>();
    static final String USER_COMMENT_KEY = "user.comment";
    static final String EXTRA_REPORT_FILE_NAME = "REPORT_FILE_NAME";
    private Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private static ErrorReporter mInstanceSingleton;
    private Context mContext;
    private ReportingInteractionMode mReportingInteractionMode = ReportingInteractionMode.SILENT;
    private Bundle mCrashResources = new Bundle();
    private static Uri mFormUri;

    public void setFormUri(Uri formUri) {
        mFormUri = formUri;
    }

    public void addCustomData(String key, String value) {
        this.mCustomParameters.put(key, value);
    }

    private String createCustomInfoString() {
        String CustomInfo = "";
        for (String CurrentKey : this.mCustomParameters.keySet()) {
            String CurrentVal = this.mCustomParameters.get(CurrentKey);
            CustomInfo = String.valueOf(CustomInfo) + CurrentKey + " = " + CurrentVal + "\n";
        }
        return CustomInfo;
    }

    public static ErrorReporter getInstance() {
        if (mInstanceSingleton == null) {
            mInstanceSingleton = new ErrorReporter();
        }
        return mInstanceSingleton;
    }

    public void init(Context context) {
        this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mContext = context;
    }

    public static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    private void retrieveCrashData(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                this.mCrashProperties.put(VERSION_NAME_KEY, pi.versionName != null ? pi.versionName : "not set");
            } else {
                this.mCrashProperties.put(PACKAGE_NAME_KEY, "Package info unavailable");
            }
            this.mCrashProperties.put(PACKAGE_NAME_KEY, context.getPackageName());
            this.mCrashProperties.put(PHONE_MODEL_KEY, Build.MODEL);
            this.mCrashProperties.put(ANDROID_VERSION_KEY, Build.VERSION.RELEASE);
            this.mCrashProperties.put(BOARD_KEY, Build.BOARD);
            this.mCrashProperties.put(BRAND_KEY, Build.BRAND);
            this.mCrashProperties.put(DEVICE_KEY, Build.DEVICE);
            this.mCrashProperties.put(DISPLAY_KEY, Build.DISPLAY);
            this.mCrashProperties.put(FINGERPRINT_KEY, Build.FINGERPRINT);
            this.mCrashProperties.put(HOST_KEY, Build.HOST);
            this.mCrashProperties.put(ID_KEY, Build.ID);
            this.mCrashProperties.put(MODEL_KEY, Build.MODEL);
            this.mCrashProperties.put(PRODUCT_KEY, Build.PRODUCT);
            this.mCrashProperties.put(TAGS_KEY, Build.TAGS);
            this.mCrashProperties.put(TIME_KEY, "" + Build.TIME);
            this.mCrashProperties.put(TYPE_KEY, Build.TYPE);
            this.mCrashProperties.put(USER_KEY, Build.USER);
            this.mCrashProperties.put(TOTAL_MEM_SIZE_KEY, "" + ErrorReporter.getTotalInternalMemorySize());
            this.mCrashProperties.put(AVAILABLE_MEM_SIZE_KEY, "" + ErrorReporter.getAvailableInternalMemorySize());
            this.mCrashProperties.put(FILE_PATH_KEY, context.getFilesDir().getAbsolutePath());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Error while retrieving crash data", (Throwable)e);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.handleException(e);
        if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e1) {
                Log.e((String)LOG_TAG, (String)"Error : ", (Throwable)e1);
            }
        }
        if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT) {
            this.mDfltExceptionHandler.uncaughtException(t, e);
        } else {
            CharSequence appName = "Application";
            try {
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    appName = pm.getApplicationInfo(this.mContext.getPackageName(), 0).loadLabel(this.mContext.getPackageManager());
                    Log.e((String)LOG_TAG, (String)(appName + " fatal error : " + e.getMessage()), (Throwable)e);
                }
                catch (PackageManager.NameNotFoundException e2) {
                    Log.e((String)LOG_TAG, (String)"Error : ", (Throwable)e2);
                    Process.killProcess((int)Process.myPid());
                    System.exit(10);
                }
            }
            finally {
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            }
        }
    }

    void handleException(Throwable e, ReportingInteractionMode reportingInteractionMode) {
        if (reportingInteractionMode == null) {
            reportingInteractionMode = this.mReportingInteractionMode;
        }
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        if (reportingInteractionMode == ReportingInteractionMode.TOAST) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    Toast.makeText((Context)ErrorReporter.this.mContext, (int)ErrorReporter.this.mCrashResources.getInt("RES_TOAST_TEXT"), (int)1).show();
                    Looper.loop();
                }
            }.start();
        }
        this.retrieveCrashData(this.mContext);
        this.mCrashProperties.put(CUSTOM_DATA_KEY, this.createCustomInfoString());
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        Log.getStackTraceString((Throwable)e);
        Throwable cause = e.getCause();
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        this.mCrashProperties.put(STACK_TRACE_KEY, ((Object)result).toString());
        printWriter.close();
        String reportFileName = this.saveCrashReportFile();
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST) {
            this.checkAndSendReports(this.mContext, null);
        } else if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            this.notifySendReport(reportFileName);
        }
    }

    public void handleException(Throwable e) {
        this.handleException(e, this.mReportingInteractionMode);
    }

    public void handleSilentException(Throwable e) {
        this.handleException(e, ReportingInteractionMode.SILENT);
    }

    void notifySendReport(String reportFileName) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        int icon = 17301624;
        if (this.mCrashResources.containsKey("RES_NOTIF_ICON")) {
            icon = this.mCrashResources.getInt("RES_NOTIF_ICON");
        }
        CharSequence tickerText = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TICKER_TEXT"));
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, tickerText, when);
        CharSequence contentTitle = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TITLE"));
        CharSequence contentText = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TEXT"));
        Intent notificationIntent = new Intent(this.mContext, CrashReportDialog.class);
        notificationIntent.putExtra(EXTRA_REPORT_FILE_NAME, reportFileName);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)notificationIntent, (int)0);
        notification.setLatestEventInfo(this.mContext, contentTitle, contentText, contentIntent);
        notificationManager.notify(666, notification);
    }

    private static void sendCrashReport(Context context, Properties errorContent) throws UnsupportedEncodingException, IOException, KeyManagementException, NoSuchAlgorithmException {
        errorContent.put("pageNumber", "0");
        errorContent.put("backupCache", "");
        errorContent.put("submit", "Envoyer");
        URL reportUrl = new URL(mFormUri.toString());
        Log.d((String)LOG_TAG, (String)("Connect to " + reportUrl.toString()));
        HttpUtils.doPost(errorContent, reportUrl);
    }

    private String saveCrashReportFile() {
        try {
            Log.d((String)LOG_TAG, (String)"Writing crash report file.");
            long timestamp = System.currentTimeMillis();
            String fileName = "stack-" + timestamp + ".stacktrace";
            FileOutputStream trace = this.mContext.openFileOutput(fileName, 0);
            this.mCrashProperties.store(trace, "");
            trace.flush();
            trace.close();
            return fileName;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"An error occured while writing the report file...", (Throwable)e);
            return null;
        }
    }

    String[] getCrashReportFilesList() {
        File dir = this.mContext.getFilesDir();
        Log.d((String)LOG_TAG, (String)("Looking for error files in " + dir.getAbsolutePath()));
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".stacktrace");
            }
        };
        return dir.list(filter);
    }

    void checkAndSendReports(Context context, String userCommentReportFileName) {
        try {
            try {
                String[] reportFilesList = this.getCrashReportFilesList();
                TreeSet<String> sortedFiles = new TreeSet<String>();
                sortedFiles.addAll(Arrays.asList(reportFilesList));
                if (reportFilesList != null && reportFilesList.length > 0) {
                    Properties previousCrashReport = new Properties();
                    int curIndex = 0;
                    boolean commentedReportFound = false;
                    for (String curFileName : sortedFiles) {
                        if (curIndex < 5) {
                            FileInputStream input = context.openFileInput(curFileName);
                            previousCrashReport.load(input);
                            input.close();
                            if (!commentedReportFound && (curFileName.equals(userCommentReportFileName) || curIndex == sortedFiles.size() - 1 && this.mCustomParameters.containsKey(USER_COMMENT_KEY))) {
                                String custom = previousCrashReport.getProperty(CUSTOM_DATA_KEY);
                                custom = custom == null ? "" : String.valueOf(custom) + "\n";
                                previousCrashReport.put(CUSTOM_DATA_KEY, String.valueOf(custom) + USER_COMMENT_KEY + " = " + this.mCustomParameters.get(USER_COMMENT_KEY));
                                this.mCustomParameters.remove(USER_COMMENT_KEY);
                            }
                            ErrorReporter.sendCrashReport(context, previousCrashReport);
                            File curFile = new File(context.getFilesDir(), curFileName);
                            curFile.delete();
                        }
                        ++curIndex;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mCustomParameters.remove(USER_COMMENT_KEY);
            }
        }
        finally {
            this.mCustomParameters.remove(USER_COMMENT_KEY);
        }
    }

    void setReportingInteractionMode(ReportingInteractionMode reportingInteractionMode) {
        this.mReportingInteractionMode = reportingInteractionMode;
    }

    public void checkReportsOnApplicationStart() {
        String[] filesList = this.getCrashReportFilesList();
        if (filesList != null && filesList.length > 0) {
            if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT || this.mReportingInteractionMode == ReportingInteractionMode.TOAST) {
                if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST) {
                    Toast.makeText((Context)this.mContext, (int)this.mCrashResources.getInt("RES_TOAST_TEXT"), (int)1).show();
                }
                new ReportsSenderWorker().start();
            } else if (this.mReportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
                ErrorReporter.getInstance().notifySendReport(null);
            }
        }
    }

    public void deletePendingReports() {
        String[] filesList = this.getCrashReportFilesList();
        if (filesList != null) {
            String[] stringArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                new File(this.mContext.getFilesDir(), fileName).delete();
                ++n2;
            }
        }
    }

    void setCrashResources(Bundle crashResources) {
        this.mCrashResources = crashResources;
    }

    public void disable() {
        if (this.mDfltExceptionHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(this.mDfltExceptionHandler);
        }
    }

    final class ReportsSenderWorker
    extends Thread {
        private String mReportFileName = null;

        ReportsSenderWorker() {
        }

        @Override
        public void run() {
            ErrorReporter.this.checkAndSendReports(ErrorReporter.this.mContext, this.mReportFileName);
        }

        void setCommentReportFileName(String reportFileName) {
            this.mReportFileName = reportFileName;
        }
    }
}

