/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import org.acra.ErrorReporter;
import org.acra.ReportingInteractionMode;

public abstract class CrashReportingApplication
extends Application
implements SharedPreferences.OnSharedPreferenceChangeListener {
    protected static final String LOG_TAG = "ACRA";
    public static final String RES_NOTIF_ICON = "RES_NOTIF_ICON";
    public static final String RES_NOTIF_TICKER_TEXT = "RES_NOTIF_TICKER_TEXT";
    public static final String RES_NOTIF_TITLE = "RES_NOTIF_TITLE";
    public static final String RES_NOTIF_TEXT = "RES_NOTIF_TEXT";
    public static final String RES_DIALOG_ICON = "RES_DIALOG_ICON";
    public static final String RES_DIALOG_TITLE = "RES_DIALOG_TITLE";
    public static final String RES_DIALOG_TEXT = "RES_DIALOG_TEXT";
    public static final String RES_DIALOG_COMMENT_PROMPT = "RES_DIALOG_COMMENT_PROMPT";
    public static final String RES_DIALOG_OK_TOAST = "RES_DIALOG_OK_TOAST";
    public static final String RES_TOAST_TEXT = "RES_TOAST_TEXT";
    public static final int NOTIF_CRASH_ID = 666;
    public static final String PREF_DISABLE_ACRA = "acra.disable";

    public void onCreate() {
        super.onCreate();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        boolean disableAcra = false;
        try {
            disableAcra = prefs.getBoolean(PREF_DISABLE_ACRA, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (disableAcra) {
            Log.d((String)LOG_TAG, (String)("ACRA is disabled for " + this.getPackageName() + "."));
            return;
        }
        this.initAcra();
    }

    private void initAcra() {
        Log.d((String)LOG_TAG, (String)("ACRA is enabled for " + this.getPackageName() + ", intializing..."));
        ErrorReporter errorReporter = ErrorReporter.getInstance();
        errorReporter.setFormUri(this.getFormUri());
        errorReporter.setReportingInteractionMode(this.getReportingInteractionMode());
        errorReporter.setCrashResources(this.getCrashResources());
        errorReporter.init(this.getApplicationContext());
        errorReporter.checkReportsOnApplicationStart();
    }

    public Uri getFormUri() {
        return Uri.parse((String)("http://spreadsheets.google.com/formResponse?formkey=" + this.getFormId() + "&amp;ifq"));
    }

    public abstract String getFormId();

    ReportingInteractionMode getReportingInteractionMode() {
        Bundle res = this.getCrashResources();
        if (res != null && res.getInt(RES_TOAST_TEXT) != 0) {
            Log.d((String)LOG_TAG, (String)"Using TOAST mode.");
            return ReportingInteractionMode.TOAST;
        }
        if (res != null && res.getInt(RES_NOTIF_TICKER_TEXT) != 0 && res.getInt(RES_NOTIF_TEXT) != 0 && res.getInt(RES_NOTIF_TITLE) != 0 && res.getInt(RES_DIALOG_TEXT) != 0) {
            Log.d((String)LOG_TAG, (String)"Using NOTIFICATION mode.");
            return ReportingInteractionMode.NOTIFICATION;
        }
        Log.d((String)LOG_TAG, (String)"Using SILENT mode.");
        return ReportingInteractionMode.SILENT;
    }

    public Bundle getCrashResources() {
        return null;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (PREF_DISABLE_ACRA.equals(key)) {
            Boolean disableAcra = false;
            try {
                disableAcra = sharedPreferences.getBoolean(key, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (disableAcra.booleanValue()) {
                ErrorReporter.getInstance().disable();
            } else {
                this.initAcra();
            }
        }
    }
}

