# android-wrapper-capacitator
All the tooling and scripts needed to package the mapcomplete.org webapp into an Android shell.

_Please, report bugs in the [main MapComplete repository](https://source.mapcomplete.org/MapComplete/MapComplete/issues)_


## To update on F-Droid

(These are notes for the maintainer)

- To update "capacitor-android", copy the 'android'-directory from "(mapcomplete repo)/node_modules/@capacitor/android" into the adroid repo root
    The path should be linked in capacitor.settings.gradle

- In the `fdroiddata`-repostiroy, open `metadata/org.mapcomplete.yml`
- Update the version number to match the MC  release
- Bump the `CurrentVersionCode` with one

Then, test the build (instructions adapted from [FDroids quick start guide](https://f-droid.org/en/docs/Submitting_to_F-Droid_Quick_Start_Guide/)):
- Go to the `fdroidserver` rep in a terminal
- Start the container with:
```
sudo docker run --rm -itu vagrant --entrypoint /bin/bash \
  -v ~/fdroiddata:/build:z \
  -v ~/fdroidserver:/home/vagrant/fdroidserver:Z \
  registry.gitlab.com/fdroid/fdroidserver:buildserver
```

In the container, run:

```
. /etc/profile
export PATH="$fdroidserver:$PATH" PYTHONPATH="$fdroidserver"
export JAVA_HOME=$(java -XshowSettings:properties -version 2>&1 > /dev/null | grep 'java.home' | awk -F'=' '{print $2}' | tr -d ' ')
cd /build
fdroid readmeta
fdroid rewritemeta org.mapcomplete
fdroid checkupdates --allow-dirty org.mapcomplete
fdroid lint org.mapcomplete
fdroid build org.mapcomplete
```
