/*
 * Based on the public domain version by Olivier Lapicque
 * Rewritten for libxmp by Claudio Matsuoka
 *
 * Copyright (C) 2012 Claudio Matsuoka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "xmp.h"
#include "common.h"
#include "mixer.h"

static const float filter_cutoff[] = {
	 130.8127899170,  132.7154998779,  134.6458892822,  136.6043548584, 
	 138.5913085938,  140.6071777344,  142.6523437500,  144.7272796631, 
	 146.8323822021,  148.9681091309,  151.1349029541,  153.3332061768, 
	 155.5634918213,  157.8262176514,  160.1218566895,  162.4508819580, 
	 164.8137817383,  167.2110443115,  169.6431884766,  172.1107025146, 
	 174.6141204834,  177.1539306641,  179.7306976318,  182.3449401855, 
	 184.9972076416,  187.6880645752,  190.4180450439,  193.1877441406, 
	 195.9977111816,  198.8485717773,  201.7408905029,  204.6752777100, 
	 207.6523437500,  210.6727142334,  213.7370300293,  216.8459014893, 
	 220.0000000000,  223.1999664307,  226.4464874268,  229.7402343750, 
	 233.0818786621,  236.4721374512,  239.9116973877,  243.4012908936, 
	 246.9416503906,  250.5334930420,  254.1775970459,  257.8746948242, 
	 261.6255798340,  265.4309997559,  269.2917785645,  273.2087097168, 
	 277.1826171875,  281.2143554688,  285.3046875000,  289.4545593262, 
	 293.6647644043,  297.9362182617,  302.2698059082,  306.6664123535, 
	 311.1269836426,  315.6524353027,  320.2437133789,  324.9017639160, 
	 329.6275634766,  334.4220886230,  339.2863769531,  344.2214050293, 
	 349.2282409668,  354.3078613281,  359.4613952637,  364.6898803711, 
	 369.9944152832,  375.3761291504,  380.8360900879,  386.3754882812, 
	 391.9954223633,  397.6971435547,  403.4817810059,  409.3505554199, 
	 415.3046875000,  421.3454284668,  427.4740600586,  433.6918029785, 
	 440.0000000000,  446.3999328613,  452.8929748535,  459.4804687500, 
	 466.1637573242,  472.9442749023,  479.8233947754,  486.8025817871, 
	 493.8833007812,  501.0669860840,  508.3551940918,  515.7493896484, 
	 523.2511596680,  530.8619995117,  538.5835571289,  546.4174194336, 
	 554.3652343750,  562.4287109375,  570.6093750000,  578.9091186523, 
	 587.3295288086,  595.8724365234,  604.5396118164,  613.3328247070, 
	 622.2539672852,  631.3048706055,  640.4874267578,  649.8035278320, 
	 659.2551269531,  668.8441772461,  678.5727539062,  688.4428100586, 
	 698.4564819336,  708.6157226562,  718.9227905273,  729.3797607422, 
	 739.9888305664,  750.7522583008,  761.6721801758,  772.7509765625, 
	 783.9908447266,  795.3942871094,  806.9635620117,  818.7011108398, 
	 830.6093750000,  842.6908569336,  854.9481201172,  867.3836059570, 
	 880.0000000000,  892.7998657227,  905.7859497070,  918.9609375000, 
	 932.3275146484,  945.8885498047,  959.6467895508,  973.6051635742, 
	 987.7666015625, 1002.1339721680, 1016.7103881836, 1031.4987792969, 
	1046.5023193359, 1061.7239990234, 1077.1671142578, 1092.8348388672, 
	1108.7304687500, 1124.8574218750, 1141.2187500000, 1157.8182373047, 
	1174.6590576172, 1191.7448730469, 1209.0792236328, 1226.6656494141, 
	1244.5079345703, 1262.6097412109, 1280.9748535156, 1299.6070556641, 
	1318.5102539062, 1337.6883544922, 1357.1455078125, 1376.8856201172, 
	1396.9129638672, 1417.2314453125, 1437.8455810547, 1458.7595214844, 
	1479.9776611328, 1501.5045166016, 1523.3443603516, 1545.5019531250, 
	1567.9816894531, 1590.7885742188, 1613.9271240234, 1637.4022216797, 
	1661.2187500000, 1685.3817138672, 1709.8962402344, 1734.7672119141, 
	1760.0000000000, 1785.5997314453, 1811.5718994141, 1837.9218750000, 
	1864.6550292969, 1891.7770996094, 1919.2935791016, 1947.2103271484, 
	1975.5332031250, 2004.2679443359, 2033.4207763672, 2062.9975585938, 
	2093.0046386719, 2123.4479980469, 2154.3342285156, 2185.6696777344, 
	2217.4609375000, 2249.7148437500, 2282.4375000000, 2315.6364746094, 
	2349.3181152344, 2383.4897460938, 2418.1584472656, 2453.3312988281, 
	2489.0158691406, 2525.2194824219, 2561.9497070312, 2599.2141113281, 
	2637.0205078125, 2675.3767089844, 2714.2910156250, 2753.7712402344, 
	2793.8259277344, 2834.4628906250, 2875.6911621094, 2917.5190429688, 
	2959.9553222656, 3003.0090332031, 3046.6887207031, 3091.0039062500, 
	3135.9633789062, 3181.5771484375, 3227.8542480469, 3274.8044433594, 
	3322.4375000000, 3370.7634277344, 3419.7924804688, 3469.5344238281, 
	3520.0000000000, 3571.1994628906, 3623.1437988281, 3675.8437500000, 
	3729.3100585938, 3783.5541992188, 3838.5871582031, 3894.4206542969, 
	3951.0664062500, 4008.5358886719, 4066.8415527344, 4125.9951171875, 
	4186.0092773438, 4246.8959960938, 4308.6684570312, 4371.3393554688, 
	4434.9218750000, 4499.4296875000, 4564.8750000000, 4631.2729492188, 
	4698.6362304688, 4766.9794921875, 4836.3168945312, 4906.6625976562, 
	4978.0317382812, 5050.4389648438, 5123.8994140625, 5198.4282226562, 
};

static const float dmpfac[] = {
	1.0000000000, 0.9812888503, 0.9629278779, 0.9449104071,
	0.9272300601, 0.9098805189, 0.8928556442, 0.8761492968,
	0.8597555757, 0.8436685801, 0.8278825879, 0.8123919964,
	0.7971912026, 0.7822748423, 0.7676376104, 0.7532742620,
	0.7391796708, 0.7253487706, 0.7117766738, 0.6984585524,
	0.6853895783, 0.6725651622, 0.6599807143, 0.6476317644,
	0.6355138421, 0.6236226559, 0.6119539738, 0.6005036235,
	0.5892674923, 0.5782416463, 0.5674220920, 0.5568050146,
	0.5463865399, 0.5361630321, 0.5261308551, 0.5162863135,
	0.5066260099, 0.4971464872, 0.4878443182, 0.4787161946,
	0.4697588682, 0.4609691501, 0.4523439109, 0.4438800514,
	0.4355745614, 0.4274244606, 0.4194268584, 0.4115789235,
	0.4038778245, 0.3963208199, 0.3889051974, 0.3816283345,
	0.3744876385, 0.3674805760, 0.3606045842, 0.3538572788,
	0.3472362161, 0.3407390118, 0.3343634009, 0.3281070888,
	0.3219678402, 0.3159434497, 0.3100318015, 0.3042307496,
	0.2985382676, 0.2929522693, 0.2874708176, 0.2820919156,
	0.2768136561, 0.2716341615, 0.2665515840, 0.2615641057,
	0.2566699386, 0.2518673539, 0.2471546233, 0.2425300926,
	0.2379920781, 0.2335389853, 0.2291692048, 0.2248811871,
	0.2206734121, 0.2165443599, 0.2124925703, 0.2085165977,
	0.2046150118, 0.2007864416, 0.1970295012, 0.1933428496,
	0.1897251904, 0.1861752123, 0.1826916784, 0.1792733073,
	0.1759189069, 0.1726272553, 0.1693972051, 0.1662275940,
	0.1631172895, 0.1600651890, 0.1570701897, 0.1541312188,
	0.1512472481, 0.1484172493, 0.1456401944, 0.1429150999,
	0.1402409971, 0.1376169324, 0.1350419670, 0.1325151771,
	0.1300356686, 0.1276025623, 0.1252149642, 0.1228720546,
	0.1205729842, 0.1183169261, 0.1161030829, 0.1139306650,
	0.1117988899, 0.1097070053, 0.1076542661, 0.1056399345,
	0.1036632955, 0.1017236337, 0.0998202711, 0.0979525223,
	0.0961197242, 0.0943212137, 0.0925563574, 0.0908245221
};


/*
 * Simple 2-poles resonant filter
 */
void filter_setup(int srate, int cutoff, int res, int *a0, int *b0, int *b1)
{
	float fc, fs = (float)srate;
	float fg, fb0, fb1;
	float d2, d, e;

	/* [0-255] => [100Hz-8000Hz] */
	CLAMP(cutoff, 0, 255);

	CLAMP(res, 0, 255);

	fc = filter_cutoff[cutoff];

	fc *= 3.14159265358979 * 2 / fs;
	d2 = dmpfac[res >> 1];
	d = (1.0 - d2) * fc;

	if (d > 2.0)
		d = 2.0;

	e = 1.0 / (fc * fc);
	d = (d2 - d) / fc + e;

	fg  = 1.0 / (1 + d);
	fb0 = (d + e) / (1 + d);
	fb1 = -e / (1 + d);

	*a0 = (int)(fg  * (1 << FILTER_SHIFT));
	*b0 = (int)(fb0 * (1 << FILTER_SHIFT));
	*b1 = (int)(fb1 * (1 << FILTER_SHIFT));
}

