package org.grating.styncynotes

import org.junit.Assert.*

import org.junit.Test

class UtilsKtTest {

    @Test
    fun map_copy() {
        val input = mapOf("a" to 1, "b" to 2, "c" to 3, "d" to 4, "e" to 5)
        var actual = input.copy("a" to 6)
        var expected = mapOf("a" to 6, "b" to 2, "c" to 3, "d" to 4, "e" to 5)
        assertEquals(expected, actual)
        actual = input.copy("a" to 1, "c" to 7, "f" to 3)
        expected = mapOf("a" to 1, "b" to 2, "c" to 7, "d" to 4, "e" to 5, "f" to 3)
        assertEquals(expected, actual)
    }

    @Test
    fun list_copy() {
        val input = listOf(1,2,3,4,5,6,7,8,9,10)
        var actual = input.copy(4 at 2)
        var expected = listOf(1,2,4,4,5,6,7,8,9,10)
        assertEquals(expected, actual)
        actual = input.copy(2 at 0, 1 at 1, 3 at 3, 4 at 2, 9 at 9, 10 at 8)
        expected = listOf(2,1,4,3,5,6,7,8,10,9)
        assertEquals(expected, actual)

        assertThrows(IndexOutOfBoundsException::class.java) {
            input.copy(2 at 0, 1 at 1, 3 at 3, 4 at 2, 9 at 9, 10 at 10)
        }
    }
}