/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui

import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.animation.core.tween
import androidx.compose.foundation.ScrollState
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithContent
import androidx.compose.ui.geometry.CornerRadius
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

@Composable
fun Modifier.simpleVerticalScrollbar(
    state: ScrollState,
    width: Dp = 8.dp
): Modifier {
    // Scrollbar Fade in/out when scrolling (shamelessly stolen from the internet)
    val targetAlpha = if (state.isScrollInProgress) 1f else 0f
    val duration = if (state.isScrollInProgress) 150 else 500
    val alpha by animateFloatAsState(
        targetValue = targetAlpha,
        animationSpec = tween(durationMillis = duration), label = ""
    )

    val sbColor = MaterialTheme.colorScheme.primary
    return drawWithContent {
        drawContent()
        val max = state.maxValue.toFloat()
        val vpt = state.viewportSize.toFloat()
        val sbh = (vpt * vpt) / (vpt + max)
        val pos = state.value.toFloat()
        if (state.isScrollInProgress) {
            val sby = pos / max * (vpt - sbh)
            drawRoundRect(
                color = sbColor,
                cornerRadius = CornerRadius(15f, 15f),
                topLeft = Offset(size.width - width.toPx(), sby),
                size = Size(width.toPx(), sbh),
                alpha = alpha
            )
        }
    }
}

