/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui.data

import org.junit.Assert.assertEquals
import org.junit.Test

class StickyPyFormatterTest {
    @Test
    fun testTranslation() {
        val testInput = fromStickyPy(SAMPLE_STICKY_PY)
        val actual = toStickyPy(testInput)
        assertEquals(SAMPLE_STICKY_PY, actual)
    }

    companion object {
        val SAMPLE_STICKY_PY: String = """
            An example note to #tag:monospace:demonstrate#tag:monospace: the different rendering functionality of StickyNotes.py and Gtk.
            #tag:bold:Bold
            #tag:italic:Italic
            #tag:monospace:Fixed Width#tag:italic:
            #tag:monospace:#tag:underline:U#tag:bold:nderlined
            #tag:strikethrough:Something struck through and underlined.
            #tag:strikethrough:#tag:highlight:Highlighted!
            #tag:small:Small
            #tag:header:Header#tag:header:
            #tag:small:#tag:large:Large Text
            #tag:large:#tag:larger:Larger Text
            #tag:underline:#tag:larger:#check:0#tag:highlight:Checklist 1
            #check:1Checklist 2
            #check:0Checklist 3
            #bullet:Bullet Point 1
            #bullet:Bullet Point 2
            #bullet:Bullet Point 3
            
            
            Normal Text
            #tag:small:Small Text
            #tag:small:#tag:large:Large Text
            #tag:large:#tag:larger:Larger Text
            #tag:header:Hea#tag:larger:#tag:small:der T#tag:small:#tag:larger:ext#tag:header:
            asdfasdfasdf
            #tag:larger:
            An example note to #tag:monospace:demonstrate#tag:monospace: the different rendering functionality of StickyNotes.py and Gtk.
            
            #tag:bold:Bold
            #tag:italic:Italic
            #tag:monospace:Fixed Width#tag:italic:
            #tag:monospace:#tag:underline:U#tag:bold:nderlined
            #tag:strikethrough:Something struck through and underlined.
            #tag:strikethrough:#tag:highlight:Highlighted!
            #tag:small:Small
            #tag:header:Header#tag:header:
            #tag:small:#tag:large:Large Text
            #tag:large:#tag:larger:Larger Text
            #tag:underline:#tag:larger:#check:0#tag:highlight:Checklist 1
            #check:1Checklist 2
            #check:0Checklist 3
            #bullet:Bullet Point 1
            #bullet:Bullet Point 2
            #bullet:Bullet Point 3
            
            
            Normal Text
            #tag:small:Small Text
            #tag:small:#tag:large:Large Text
            #tag:large:#tag:larger:Larger Text
            #tag:header:Hea#tag:larger:#tag:small:der T#tag:small:#tag:larger:ext#tag:header:
            asdfasdfasdf
            #tag:larger:
        """.trimIndent()
    }
}