/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui.screens

import androidx.compose.foundation.lazy.staggeredgrid.LazyVerticalStaggeredGrid
import androidx.compose.foundation.lazy.staggeredgrid.StaggeredGridCells
import androidx.compose.foundation.lazy.staggeredgrid.items
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import org.grating.styncynotes.data.Note
import org.grating.styncynotes.ui.model.StyncyNotesViewModel

@Composable
fun NotesScreen(
    viewModel: StyncyNotesViewModel,
    onNoteSelected: (Note) -> Unit,
    onColorChangeRequested: (Note) -> Unit,
    onDeleteRequested: (Note) -> Unit
) {
    val uiState = viewModel.uiState.collectAsState().value
    LazyVerticalStaggeredGrid(columns = StaggeredGridCells.Fixed(2)) {
        items(uiState.notes) { note ->
            NoteCard(viewModel = viewModel,
                     note = note,
                     showFormat = false,
                     scrollable = false,
                     onColorChangeRequested = {
                         onColorChangeRequested(note)
                     },
                     onDeleteRequested = {
                         onDeleteRequested(note)
                     },
                     onNoteSelected = {
                         onNoteSelected(note)
                     },
                     maxHeight = 500)
        }
    }
}
