/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui.model

import org.grating.styncynotes.at
import org.grating.styncynotes.copy
import org.grating.styncynotes.data.Note

const val UNSET = ""

data class StyncyNotesUiState(
    val groups: Map<String,List<Note>> = emptyMap(),
    val group: String = UNSET,
    val pendingGroupName: String = UNSET,
    val notes: List<Note> = emptyList(),
    val note: Note? = null,
    val confirmationMsg: String = UNSET,
    val confirmationAction: () -> Unit = {},
    val errorNotificationMessage: String = UNSET,
    val softKeyboardInUse: Boolean = false
) {
    fun copy(note: Note?): StyncyNotesUiState {
        return if(note != null) {
            copy(notes = notes.copy(note at note.idx), note = note)
        } else {
            copy(notes = notes, note = null)
        }
    }
}

