# StyncyNotes
<img src="https://gitlab.com/gbygrave/styncynotes/-/badges/release.svg">
<img src="https://gitlab.com/gbygrave/styncynotes/badges/main/pipeline.svg?ignore_skipped=true">
<img src="https://gitlab.com/gbygrave/styncynotes/badges/main/coverage.svg">


### Sticky Notes + SyncThing == StyncyNotes

StyncyNotes is a simple note taking application that can be used stand alone but is really meant to work in conjunction with Syncthing and the Sticky.py notes application for linux.
StyncyNotes reads and writes the Sticky.py note file format and you can use SyncThing to keep the StyncyNotes file (which you save under shared storage) and the Sticky.py notes file (in ~/config/notes.json) in step.
You can find the Desktop app (nothing to do with me, I just use it) for linux, [here](https://github.com/linuxmint/sticky).

# Status
Most functionality is working.  Not aware of any show stoppers.  Can't move notes around on screen or between groups, yet.  Might implement this if I find a pressing need to do it.


## Screenshots
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot1.jpg" alt="User Interface Image 1">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot2.jpg" alt="User Interface Image 2">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot3.jpg" alt="User Interface Image 3">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot4.jpg" alt="User Interface Image 4">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot5.jpg" alt="User Interface Image 5">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot6.jpg" alt="User Interface Image 6">
<img width="290" src="metadata/en-US/images/phoneScreenshots/screenShot7.jpg" alt="User Interface Image 7">

## Short Video Demo
[<img src="metadata/en-US/images/DemoVideoStill.png" 
       alt="Demo Video"
       height="200">](https://youtu.be/toesDQrrKIU)

## UI Installation
The easiest way to install the UI is via [F-Droid](https://f-droid.org/en/packages/org.grating.styncynotes/).  Alternatively, you can manually grab the [apk](https://gitlab.com/gbygrave/styncynotes/-/releases/v1.0/downloads/app-release.apk), or if you have AndroidStudio you can git clone the repository and install to your device via a remote debug session.  

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/org.grating.styncynotes/)

Or download from the [Releases Section](https://gitlab.com/gbygrave/styncynotes/-/releases) here on Gitlab.

## SyncThing Installation
For sharing with linuxmint/Sticky, you can install SyncThing on your android phone and on your linux desktop and sync the desktop folder (typically under ~/.config/sticky) with the folder you store your notes.json file in on your phone.  Note: If sharing folders, you'll need to make sure the notes file is called notes.json although you can place this anywhere on shared storage you want to.

Find out all you need to know to get SyncThing working here:
https://syncthing.net/

**_StyncyNotes_** will notice if/when SyncThing updates the underlying notes file and reload it for you without you having to do anything.  **_StickyNotes_** requires some encouragement however when syncing happens in the other direction.
There are two suggested ways to do this:
1. Use inotify in Linux to notice when the file has been updated by SyncThing and then message StickyNotes via DBUS.
2. Regularly poll SyncThing to check if a relevant update has occurred and then message StickyNotes via DBUS.

### Using inotify
Install inotify where StickyNotes runs and write a script to monitor your notes file like so:
#!/bin/bash

    inotifywait -m -e move \
        "/home/YOURUSERNAME/.config/sticky" | while read DIR EVENT FILE
        do
            if [[ ${EVENT} == "MOVED_TO" ]] && [[ ${FILE} == "notes.json" ]]
            then
                dbus-send --type=method_call --dest=org.x.sticky /org/x/sticky org.x.sticky.ReloadNotesFromFile
            fi
        done

Thanks to [@goebbe](https://gitlab.com/goebbe) for this solution - he has also written a [HowTo](https://forums.linuxmint.com/viewtopic.php?p=2693031#p2693031) with more detail.

### Using HookThing
Setup [HookThing](https://gitlab.com/gbygrave/hookthing) under systemd to monitor your local SyncThing daemon and send the relevant DBUS message when SyncThing performs a Sync of the local file. 

## Support
If you get stuck, send direct email to styncynotes@bygrave.org

## Roadmap
Nothing in particular.  I use this myself as an alternative to Google Keep so I can keep using StickyNotes (which is my favourite desktop notes app).  I'll implement things I feel are lacking as I use it.  Suggestions welcome.

## Contributing
Feel free.

## Authors and acknowledgement
Graham bygrave

## License
GPLv3 or later.

## Project Status
Active development.
