/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui.data

import org.grating.styncynotes.showSpanStyleDeltasAlongsideText
import org.junit.Assert.assertEquals
import org.junit.Test

class StickyPyParserTest {

    @Test
    fun testTranslation() {
        val stickyString = fromStickyPy(sampleStickyPy)
        val actual = showSpanStyleDeltasAlongsideText(stickyString.annotatedString)
        assertEquals(expectedAnnotatedString, actual)
    }

    private val sampleStickyPy: String = """
        An example note to #tag:monospace:demonstrate#tag:monospace: the different rendering functionality of StickyNotes.py and Gtk.
        #tag:bold:Bold
        #tag:italic:Italic
        #tag:monospace:Fixed Width#tag:italic:
        #tag:monospace:#tag:underline:U#tag:bold:nderlined
        #tag:strikethrough:Something struck through and underlined.
        #tag:strikethrough:#tag:highlight:Highlighted!
        #tag:small:Small
        #tag:header:Header#tag:header:
        #tag:small:#tag:large:Large Text
        #tag:large:#tag:larger:Larger Text
        #tag:underline:#tag:larger:#check:0#tag:highlight:Checklist 1
        #check:1Checklist 2
        #check:0Checklist 3
        #bullet:Bullet Point 1
        #bullet:Bullet Point 2
        #bullet:Bullet Point 3
        
        
        Normal Text
        #tag:small:Small Text
        #tag:small:#tag:large:Large Text
        #tag:large:#tag:larger:Larger Text
        #tag:header:Hea#tag:larger:#tag:small:der T#tag:small:#tag:larger:ext#tag:header:
        asdfasdfasdf
        #tag:larger:
        An example note to #tag:monospace:demonstrate#tag:monospace: the different rendering functionality of StickyNotes.py and Gtk.
        
        #tag:bold:Bold
        #tag:italic:Italic
        #tag:monospace:Fixed Width#tag:italic:
        #tag:monospace:#tag:underline:U#tag:bold:nderlined
        #tag:strikethrough:Something struck through and underlined.
        #tag:strikethrough:#tag:highlight:Highlighted!
        #tag:small:Small
        #tag:header:Header#tag:header:
        #tag:small:#tag:large:Large Text
        #tag:large:#tag:larger:Larger Text
        #tag:underline:#tag:larger:#check:0#tag:highlight:Checklist 1
        #check:1Checklist 2
        #check:0Checklist 3
        #bullet:Bullet Point 1
        #bullet:Bullet Point 2
        #bullet:Bullet Point 3
        
        
        Normal Text
        #tag:small:Small Text
        #tag:small:#tag:large:Large Text
        #tag:large:#tag:larger:Larger Text
        #tag:header:Hea#tag:larger:#tag:small:der T#tag:small:#tag:larger:ext#tag:header:
        asdfasdfasdf
        #tag:larger:
    """.trimIndent()
}

private val expectedAnnotatedString: String = """
    <SpanStyle(Unspecified->14.0.sp)>An example note to <SpanStyle(null->FontFamily.Monospace)>demonstrate<SpanStyle(FontFamily.Monospace->FontFamily.Default)> the different rendering functionality of StickyNotes.py and Gtk.
    <SpanStyle(null->FontWeight(weight=700))>Bold
    <SpanStyle(null->Italic)>Italic
    <SpanStyle(FontFamily.Default->FontFamily.Monospace)>Fixed Width<SpanStyle(Italic->Normal)>
    <SpanStyle(FontFamily.Monospace->FontFamily.Default)><SpanStyle(null->TextDecoration.Underline)>U<SpanStyle(FontWeight(weight=700)->FontWeight(weight=400))>nderlined
    <SpanStyle(TextDecoration.Underline->TextDecoration[Underline, LineThrough])>Something struck through and underlined.
    <SpanStyle(TextDecoration[Underline, LineThrough]->TextDecoration.Underline)><SpanStyle(Color(0.0, 0.0, 0.0, 0.0, None)->Color(1.0, 1.0, 0.0, 1.0, sRGB IEC61966-2.1))>Highlighted!
    <SpanStyle(14.0.sp->11.9.sp)>Small
    <SpanStyle(11.9.sp->19.04.sp)>Header<SpanStyle(19.04.sp->11.9.sp)>
    <SpanStyle(11.9.sp->14.0.sp)><SpanStyle(14.0.sp->18.2.sp)>Large Text
    <SpanStyle(18.2.sp->14.0.sp)><SpanStyle(14.0.sp->21.0.sp)>Larger Text
    <SpanStyle(TextDecoration.Underline->TextDecoration.None)><SpanStyle(21.0.sp->14.0.sp)> ☐ <SpanStyle(Color(1.0, 1.0, 0.0, 1.0, sRGB IEC61966-2.1)->Color(0.0, 0.0, 0.0, 0.0, sRGB IEC61966-2.1))>Checklist 1
     ☑ Checklist 2
     ☐ Checklist 3
     • Bullet Point 1
     • Bullet Point 2
     • Bullet Point 3


    Normal Text
    <SpanStyle(14.0.sp->11.9.sp)>Small Text
    <SpanStyle(11.9.sp->14.0.sp)><SpanStyle(14.0.sp->18.2.sp)>Large Text
    <SpanStyle(18.2.sp->14.0.sp)><SpanStyle(14.0.sp->21.0.sp)>Larger Text
    <SpanStyle(21.0.sp->33.6.sp)>Hea<SpanStyle(33.6.sp->22.4.sp)><SpanStyle(22.4.sp->19.04.sp)>der T<SpanStyle(19.04.sp->22.4.sp)><SpanStyle(22.4.sp->33.6.sp)>ext<SpanStyle(33.6.sp->21.0.sp)>
    asdfasdfasdf
    <SpanStyle(21.0.sp->14.0.sp)>
    An example note to <SpanStyle(FontFamily.Default->FontFamily.Monospace)>demonstrate<SpanStyle(FontFamily.Monospace->FontFamily.Default)> the different rendering functionality of StickyNotes.py and Gtk.

    <SpanStyle(FontWeight(weight=400)->FontWeight(weight=700))>Bold
    <SpanStyle(Normal->Italic)>Italic
    <SpanStyle(FontFamily.Default->FontFamily.Monospace)>Fixed Width<SpanStyle(Italic->Normal)>
    <SpanStyle(FontFamily.Monospace->FontFamily.Default)><SpanStyle(TextDecoration.None->TextDecoration.Underline)>U<SpanStyle(FontWeight(weight=700)->FontWeight(weight=400))>nderlined
    <SpanStyle(TextDecoration.Underline->TextDecoration[Underline, LineThrough])>Something struck through and underlined.
    <SpanStyle(TextDecoration[Underline, LineThrough]->TextDecoration.Underline)><SpanStyle(Color(0.0, 0.0, 0.0, 0.0, sRGB IEC61966-2.1)->Color(1.0, 1.0, 0.0, 1.0, sRGB IEC61966-2.1))>Highlighted!
    <SpanStyle(14.0.sp->11.9.sp)>Small
    <SpanStyle(11.9.sp->19.04.sp)>Header<SpanStyle(19.04.sp->11.9.sp)>
    <SpanStyle(11.9.sp->14.0.sp)><SpanStyle(14.0.sp->18.2.sp)>Large Text
    <SpanStyle(18.2.sp->14.0.sp)><SpanStyle(14.0.sp->21.0.sp)>Larger Text
    <SpanStyle(TextDecoration.Underline->TextDecoration.None)><SpanStyle(21.0.sp->14.0.sp)> ☐ <SpanStyle(Color(1.0, 1.0, 0.0, 1.0, sRGB IEC61966-2.1)->Color(0.0, 0.0, 0.0, 0.0, sRGB IEC61966-2.1))>Checklist 1
     ☑ Checklist 2
     ☐ Checklist 3
     • Bullet Point 1
     • Bullet Point 2
     • Bullet Point 3


    Normal Text
    <SpanStyle(14.0.sp->11.9.sp)>Small Text
    <SpanStyle(11.9.sp->14.0.sp)><SpanStyle(14.0.sp->18.2.sp)>Large Text
    <SpanStyle(18.2.sp->14.0.sp)><SpanStyle(14.0.sp->21.0.sp)>Larger Text
    <SpanStyle(21.0.sp->33.6.sp)>Hea<SpanStyle(33.6.sp->22.4.sp)><SpanStyle(22.4.sp->19.04.sp)>der T<SpanStyle(19.04.sp->22.4.sp)><SpanStyle(22.4.sp->33.6.sp)>ext<SpanStyle(33.6.sp->21.0.sp)>
    asdfasdfasdf
    <SpanStyle(21.0.sp->14.0.sp)>
""".trimIndent()
