/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.data

import androidx.compose.ui.text.SpanStyle
import org.grating.styncynotes.ui.richertext.Format
import org.grating.styncynotes.ui.richertext.Format.Companion.MONOSPACE
import org.grating.styncynotes.ui.richertext.Format.Companion.SMALL
import org.junit.Assert.*

import org.junit.Test

class FormatTest {
    @Test
    fun toggle() {
        val flags = Format.EMPTY_FLAGS
        val (_, actual1) = MONOSPACE.toggle(SpanStyle(), flags)
        val expected1 = "__M_______"
        assertEquals(expected1, actual1)

        val (_, actual2) = SMALL.toggle(SpanStyle(), actual1)
        val expected2 = "__M___S___"
        assertEquals(expected2, actual2)

        val (_, actual3) = MONOSPACE.toggle(SpanStyle(), actual2)
        val expected3 = "______S___"
        assertEquals(expected3, actual3)

    }
}