/* Copyright (C) 2024 Graham Bygrave
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.grating.styncynotes.ui.screens

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import org.grating.styncynotes.ui.data.BULLET
import org.grating.styncynotes.ui.data.CHECKBOX_UNTICKED
import org.grating.styncynotes.ui.data.fromStickyPy
import org.grating.styncynotes.ui.richertext.Format
import org.grating.styncynotes.ui.richertext.Format.Companion.FORMATS

@Composable
fun FormatChooser(
    onFormatSelected: (Format) -> Unit,
    onToggleCheckboxList: () -> Unit,
    onToggleBulletList: () -> Unit
) {
    Column {
        for (format in FORMATS) {
            Button(onClick = {
                onFormatSelected(format)
            }) {
                Row {
                    Text(text = fromStickyPy("${format.tag}${format.name}").annotatedString)
                }
            }
        }

        // Now wangle in bullets and checkpoints.
        Button(onClick = {
            onToggleCheckboxList()
        }) {
            Row {
                Text(text = "$CHECKBOX_UNTICKED Toggle Checklist")
            }
        }
        Button(onClick = {
            onToggleBulletList()
        }) {
            Row {
                Text(text = "$BULLET Toggle Bullets")
            }
        }

    }
}
