/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.InternetExplorerEngine;
import org.jdesktop.jdic.browser.MozillaEngine;
import org.jdesktop.jdic.browser.WebKitEngine;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class BrowserEngineManager {
    private static final String ORG_JDESKTOP_JDIC_BROWSER_BROWSERMANAGER = "org.jdesktop.jdic.browser.BrowserManager";
    private static BrowserEngineManager managerInstance = null;
    public static String MOZILLA = "Mozilla";
    public static String IE = "Internet Explorer";
    public static String WEBKIT = "WebKit";
    private static Map engines = new HashMap();
    private static IBrowserEngine activeEngine = null;

    private BrowserEngineManager() {
        this.initExitingEngines();
    }

    protected void initExitingEngines() {
        this.registerBrowserEngine(IE, new InternetExplorerEngine());
        this.registerBrowserEngine(MOZILLA, new MozillaEngine());
        this.registerBrowserEngine(WEBKIT, new WebKitEngine());
    }

    public static synchronized BrowserEngineManager instance() {
        if (managerInstance == null) {
            String string = System.getProperty(ORG_JDESKTOP_JDIC_BROWSER_BROWSERMANAGER);
            WebBrowserUtil.trace("Specified browserManager " + string);
            if (string != null) {
                try {
                    managerInstance = (BrowserEngineManager)Class.forName(string).newInstance();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (managerInstance == null) {
                WebBrowserUtil.trace("Default browserManager is used.");
                managerInstance = new BrowserEngineManager();
            }
        }
        return managerInstance;
    }

    public Map getEngines() {
        return engines;
    }

    public boolean registerBrowserEngine(String string, IBrowserEngine iBrowserEngine) {
        if (engines.containsKey(string)) {
            WebBrowserUtil.trace("Engine " + string + " has been registered.");
            return true;
        }
        if (iBrowserEngine == null) {
            WebBrowserUtil.error("Engine " + string + " is null.");
            return false;
        }
        if (this.checkEnginesWhenAdded()) {
            if (iBrowserEngine.isEngineAvailable()) {
                engines.put(string, iBrowserEngine);
                return true;
            }
        } else {
            engines.put(string, iBrowserEngine);
            return true;
        }
        return false;
    }

    public boolean removeBrowserEngine(String string) {
        if (!engines.containsKey(string)) {
            return true;
        }
        IBrowserEngine iBrowserEngine = (IBrowserEngine)engines.get(string);
        if (iBrowserEngine == activeEngine) {
            WebBrowserUtil.error("Can't remove active engine!");
            return false;
        }
        WebBrowserUtil.trace("Engine " + string + " will be removed.");
        return engines.remove(string) != null;
    }

    protected void selectEngine() throws JdicInitException {
        if (activeEngine != null) {
            WebBrowserUtil.trace("Engine " + activeEngine.getBrowserName() + " is active,won't select.");
            return;
        }
        String string = WebBrowserUtil.getDefaultBrowserPath();
        if (null == string) {
            WebBrowserUtil.trace("No defaultBrowser is detected! You must specify a browser engine by setActiveEngine()!");
            return;
        }
        Iterator iterator = engines.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            IBrowserEngine iBrowserEngine = (IBrowserEngine)engines.get(string2);
            if (!iBrowserEngine.isDefaultBrowser(string) || !iBrowserEngine.isEngineAvailable()) continue;
            activeEngine = iBrowserEngine;
            break;
        }
        if (activeEngine == null) {
            WebBrowserUtil.trace("No browser is selected as active,you must specify one by setActiveEngine()!");
        }
    }

    protected boolean checkEnginesWhenAdded() {
        return true;
    }

    public IBrowserEngine setActiveEngine(String string) {
        if (activeEngine != null && activeEngine.isInitialized()) {
            WebBrowserUtil.error("Engine " + activeEngine.getBrowserName() + "has been initialized,can't change it anymore!");
        }
        if (!engines.containsKey(string)) {
            WebBrowserUtil.error("Can't find engine " + string);
            return null;
        }
        IBrowserEngine iBrowserEngine = (IBrowserEngine)engines.get(string);
        if (iBrowserEngine == activeEngine) {
            return activeEngine;
        }
        if (!iBrowserEngine.isEngineAvailable()) {
            WebBrowserUtil.trace("Engine " + string + " isn't available.");
            return null;
        }
        activeEngine = iBrowserEngine;
        WebBrowserUtil.trace("Engine " + string + " is set as activeEngine.");
        return activeEngine;
    }

    public IBrowserEngine getActiveEngine() {
        if (activeEngine == null) {
            try {
                this.selectEngine();
            }
            catch (JdicInitException jdicInitException) {
                WebBrowserUtil.error(jdicInitException.getMessage());
                jdicInitException.printStackTrace();
            }
        }
        return activeEngine;
    }
}

