/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import net.sbbi.upnp.jmx.UPNPMBeanDevicesDiscoveryHandler;
import net.sbbi.upnp.jmx.UPNPMBeanDevicesRequestsHandler;
import net.sbbi.upnp.jmx.UPNPMBeanService;

public class UPNPMBeanDevice {
    private static String libVersion = null;
    public static final String IMPL_NAME;
    public static int DEFAULT_MAX_AGE;
    public static int DEFAULT_TTL;
    private static InetSocketAddress defaultBindAddr;
    private String uuid;
    private String internalId;
    private String deviceInfo;
    private InetSocketAddress bindAddress;
    private String location;
    private boolean rootDevice = true;
    private boolean started = false;
    private List childrens = new ArrayList();
    private List services = new ArrayList();
    private String vendorDomain;
    private String deviceType;
    private String manufacturer;
    private int deviceVersion;
    private String friendlyName;
    private String modelName;
    private URL manufacturerURL;
    private String modelDescription;
    private String modelNumber;
    private URL modelURL;
    private String serialNumber;
    private String UPC;
    private int SSDPAliveDelay = DEFAULT_MAX_AGE;
    private int SSDPTTL = DEFAULT_TTL;

    public UPNPMBeanDevice(String deviceType, int deviceVersion, String manufacturer, String friendlyName, String modelName, String internalId) throws RuntimeException {
        this("urn:schemas-upnp-org", deviceType, deviceVersion, manufacturer, friendlyName, modelName, internalId);
    }

    public UPNPMBeanDevice(String vendorDomain, String deviceType, int deviceVersion, String manufacturer, String friendlyName, String modelName, String internalId) throws RuntimeException {
        this.vendorDomain = vendorDomain;
        this.deviceVersion = deviceVersion;
        this.deviceType = "urn:" + this.vendorDomain + ":device:" + deviceType + ":" + this.deviceVersion;
        this.manufacturer = manufacturer;
        this.friendlyName = friendlyName;
        this.modelName = modelName;
        this.internalId = internalId;
        if (this.internalId == null) {
            this.internalId = this.deviceType;
        }
        this.bindAddress = defaultBindAddr;
        this.generateDeviceUUID();
    }

    public void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        this.generateDeviceUUID();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getSSDPAliveDelay() {
        return this.SSDPAliveDelay;
    }

    public void setSSDPAliveDelay(int aliveDelay) {
        if (aliveDelay < DEFAULT_MAX_AGE) {
            throw new IllegalArgumentException("SSDPAliveDelay must be greater than " + DEFAULT_MAX_AGE + " secs");
        }
        this.SSDPAliveDelay = aliveDelay;
    }

    public int getSSDPTTL() {
        return this.SSDPTTL;
    }

    public void setSSDPTTL(int ssdpttl) {
        this.SSDPTTL = ssdpttl;
    }

    protected UPNPMBeanService getUPNPMBeanService(String serviceUuid) {
        Iterator i = this.services.iterator();
        while (i.hasNext()) {
            UPNPMBeanService srv = (UPNPMBeanService)i.next();
            if (!srv.getServiceUUID().equals(serviceUuid)) continue;
            return srv;
        }
        return null;
    }

    protected List getUPNPMBeanServices() {
        return this.services;
    }

    protected List getUPNPMBeanChildrens() {
        return this.childrens;
    }

    protected String getUuid() {
        return this.uuid;
    }

    protected String getDeviceInfo() {
        return this.deviceInfo;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected String getLocation() {
        return this.location;
    }

    protected String getDeviceType() {
        return this.deviceType;
    }

    protected boolean isRootDevice() {
        return this.rootDevice;
    }

    public void addChildMBean(UPNPMBeanDevice device) {
        device.rootDevice = false;
        this.childrens.add(device);
    }

    public void addService(ModelMBean mbean, ObjectName beanName, MBeanServer targetServer, String serviceId, String serviceType, int serviceVersion) throws IOException {
        this.addService(mbean.getMBeanInfo(), beanName, targetServer, serviceId, serviceType, serviceVersion);
    }

    public void addService(DynamicMBean mbean, ObjectName beanName, MBeanServer targetServer, String serviceId, String serviceType, int serviceVersion) throws IOException {
        this.addService(mbean.getMBeanInfo(), beanName, targetServer, serviceId, serviceType, serviceVersion);
    }

    public void addService(Object mbean, ObjectName beanName, MBeanServer targetServer, String serviceId, String serviceType, int serviceVersion) throws IOException, IntrospectionException, InstanceNotFoundException, ReflectionException {
        this.addService(targetServer.getMBeanInfo(beanName), beanName, targetServer, serviceId, serviceType, serviceVersion);
    }

    public void addService(MBeanInfo info, ObjectName beanName, MBeanServer targetServer, String serviceId, String serviceType, int serviceVersion) throws IOException {
        UPNPMBeanService deviceService = new UPNPMBeanService(this.uuid, this.vendorDomain, serviceId, serviceType, serviceVersion, info, beanName, targetServer);
        String newServiceType = deviceService.getServiceType();
        Iterator i = this.services.iterator();
        while (i.hasNext()) {
            UPNPMBeanService srv = (UPNPMBeanService)i.next();
            if (!srv.getServiceType().equals(newServiceType)) continue;
            throw new IOException("Service type " + serviceType + " for MBeans " + beanName + " is already used by MBeans " + srv.getObjectName() + ", you must use an unique service type");
        }
        this.services.add(deviceService);
    }

    private void generateDeviceUUID() {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(this.deviceType.getBytes());
            md5.update(this.internalId.getBytes());
            md5.update(this.bindAddress.getHostName().getBytes());
            StringBuffer hexString = new StringBuffer();
            byte[] digest = md5.digest();
            for (int i = 0; i < digest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & digest[i]));
            }
            this.uuid = hexString.toString().toUpperCase();
        }
        catch (Exception ex) {
            RuntimeException runTimeEx = new RuntimeException("Unexpected error during MD5 hash creation, check your JRE");
            runTimeEx.initCause(ex);
            throw runTimeEx;
        }
    }

    public void start() throws Exception {
        if (!this.started) {
            if (this.services.size() == 0) {
                throw new Exception("No UPNP service defined");
            }
            this.deviceInfo = this.getRootDeviceInfo(this.bindAddress, this.uuid);
            this.location = "http://" + this.bindAddress.getAddress().getHostAddress() + ":" + this.bindAddress.getPort() + "/" + this.uuid + "/desc.xml";
            UPNPMBeanDevicesRequestsHandler.getInstance(this.bindAddress).addUPNPMBeanDevice(this);
            UPNPMBeanDevicesDiscoveryHandler.getInstance(this.bindAddress).addUPNPMBeanDevice(this);
            this.started = true;
        }
    }

    private static InetSocketAddress getUPNPMBeansBoundAddr() {
        String boundAdr = System.getProperty("net.sbbi.upnp.UPNPMBeanDevice.boundAddr");
        InetSocketAddress defaultBoundAddr = null;
        try {
            InetAddress adr = null;
            adr = boundAdr != null ? InetAddress.getByName(boundAdr) : InetAddress.getLocalHost();
            defaultBoundAddr = new InetSocketAddress(adr, 8895);
        }
        catch (IOException ex) {
            defaultBoundAddr = new InetSocketAddress("localhost", 8895);
        }
        return defaultBoundAddr;
    }

    public void stop() throws IOException {
        if (this.started) {
            UPNPMBeanDevicesRequestsHandler.getInstance(this.bindAddress).removeUPNPMBeanDevice(this);
            UPNPMBeanDevicesDiscoveryHandler.getInstance(this.bindAddress).removeUPNPMBeanDevice(this);
        }
    }

    private String getRootDeviceInfo(InetSocketAddress adr, String uuid) {
        StringBuffer rtrVal = new StringBuffer();
        rtrVal.append("<?xml version=\"1.0\" ?>\r\n");
        rtrVal.append("<root xmlns=\"urn:schemas-upnp-org:device-1-0\">\r\n");
        rtrVal.append("<specVersion><major>1</major><minor>0</minor></specVersion>\r\n");
        rtrVal.append("<URLBase>http://").append(adr.getAddress().getHostAddress()).append(":").append(adr.getPort()).append("</URLBase>\r\n");
        this.getDeviceInfo(this, rtrVal);
        rtrVal.append("</root>");
        return rtrVal.toString();
    }

    private void getDeviceInfo(UPNPMBeanDevice device, StringBuffer buffer) {
        buffer.append("<device>\r\n");
        buffer.append("<deviceType>").append(device.deviceType).append("</deviceType>\r\n");
        buffer.append("<friendlyName>").append(device.friendlyName).append("</friendlyName>\r\n");
        buffer.append("<manufacturer>").append(device.manufacturer).append("</manufacturer>\r\n");
        if (device.manufacturerURL != null) {
            buffer.append("<manufacturerURL>").append(device.manufacturerURL).append("</manufacturerURL>\r\n");
        }
        if (device.modelDescription != null) {
            buffer.append("<modelDescription>").append(device.modelDescription).append("</modelDescription>\r\n");
        }
        buffer.append("<modelName>").append(device.modelName).append("</modelName>\r\n");
        if (device.modelNumber != null) {
            buffer.append("<modelNumber>").append(device.modelNumber).append("</modelNumber>\r\n");
        }
        if (device.modelURL != null) {
            buffer.append("<modelURL>").append(device.modelURL).append("</modelURL>\r\n");
        }
        if (device.serialNumber != null) {
            buffer.append("<serialNumber>").append(device.serialNumber).append("</serialNumber>\r\n");
        }
        buffer.append("<UDN>uuid:").append(device.uuid).append("</UDN>\r\n");
        if (device.UPC != null) {
            buffer.append("<UPC>").append(device.serialNumber).append("</UPC>\r\n");
        }
        buffer.append("<serviceList>\r\n");
        Iterator i = device.services.iterator();
        while (i.hasNext()) {
            UPNPMBeanService srv = (UPNPMBeanService)i.next();
            buffer.append(srv.getServiceInfo());
        }
        buffer.append("</serviceList>\r\n");
        if (device.childrens.size() > 0) {
            buffer.append("<deviceList>\r\n");
            i = device.childrens.iterator();
            while (i.hasNext()) {
                UPNPMBeanDevice dv = (UPNPMBeanDevice)i.next();
                this.getDeviceInfo(dv, buffer);
            }
            buffer.append("</deviceList>\r\n");
        }
        buffer.append("</device>\r\n");
    }

    static {
        Properties props = new Properties();
        try {
            props.load(UPNPMBeanDevice.class.getClassLoader().getResourceAsStream("net/sbbi/upnp/version.properties"));
            libVersion = props.getProperty("release.version");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        IMPL_NAME = System.getProperty("os.name") + " UPnP/1.0 SuperBonBon Industries JMX UPNP/" + libVersion;
        DEFAULT_MAX_AGE = 1800;
        DEFAULT_TTL = 4;
        defaultBindAddr = UPNPMBeanDevice.getUPNPMBeansBoundAddr();
    }
}

