/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.jdic.tray.internal.TrayIconService;

public class MacTrayIconService
implements TrayIconService {
    private JPopupMenu menu;
    private Icon icon;
    private boolean autoSize;
    private String caption;
    private String toolTipText;
    private long nsStatusItemWrapperPointer;
    private static HashMap map = new HashMap();
    private LinkedList actionList = new LinkedList();
    private final int MAC_STATUSBAR_ICON_WIDTH = 22;
    private final int MAC_STATUSBAR_ICON_HEIGHT = 22;
    private boolean nativePeerExists = false;
    private boolean showingPopoup;
    AnimationObserver observer;
    static PopupParent popupParentFrame;

    public MacTrayIconService() {
        if (popupParentFrame == null) {
            popupParentFrame = new PopupParent();
            popupParentFrame.pack();
            popupParentFrame.setVisible(true);
        }
    }

    private native long createStatusItem();

    private native void removeStatusItem(long var1);

    private native void setImageNative(long var1, byte[] var3, int var4, int var5, int var6, int var7, boolean var8, boolean var9, String var10, int var11, int var12);

    private native void setTitleNative(long var1, String var3);

    private native void setToolTipNative(long var1, String var3);

    private native void setIsArmedNative(long var1, boolean var3);

    private native void getLocationOnScreenNative(long var1, float[] var3);

    public void showBalloonMessage(String string, String string2, int n) {
        throw new UnsupportedOperationException("Method showBalloonMessage is unsupported under Mac!");
    }

    public void addNotify() {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MacTrayIconService.this.addImpl();
                }
            };
            new Thread(runnable).start();
        } else {
            this.addImpl();
        }
    }

    private synchronized void addImpl() {
        if (!this.nativePeerExists) {
            this.nsStatusItemWrapperPointer = this.createStatusItem();
            this.setTitleNative(this.nsStatusItemWrapperPointer, this.caption);
            this.setToolTipNative(this.nsStatusItemWrapperPointer, this.toolTipText);
            this.nativePeerExists = true;
            this.updateIcon();
        }
    }

    void updateIcon() {
        if (this.icon != null) {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            int n3;
            BufferedImage bufferedImage = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            this.icon.paintIcon(this.observer, graphics2D, 0, 0);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n4 = byArray.length;
            for (n3 = 0; n3 < n4; n3 += 4) {
                n2 = byArray[n3];
                n = byArray[n3 + 1];
                bl2 = byArray[n3 + 2];
                byArray[n3] = bl = byArray[n3 + 3];
                byArray[n3 + 1] = bl2;
                byArray[n3 + 2] = n;
                byArray[n3 + 3] = n2;
            }
            n3 = writableRaster.getWidth();
            n4 = writableRaster.getHeight();
            n2 = writableRaster.getNumBands();
            n = 8;
            bl2 = true;
            bl = false;
            String string = "NSCalibratedRGBColorSpace";
            int n5 = n3 * n2;
            int n6 = n2 * n;
            if (this.nativePeerExists) {
                this.setImageNative(this.nsStatusItemWrapperPointer, byArray, n3, n4, n, n2, bl2, bl, string, n5, n6);
            }
        }
    }

    private void temp() {
        BufferedImage bufferedImage = null;
        if (this.icon != null && bufferedImage == null) {
            bufferedImage = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            this.icon.paintIcon(null, graphics2D, 0, 0);
            BufferedImage bufferedImage2 = bufferedImage;
            System.out.println("type of BufferedImage is " + bufferedImage.getClass().getName());
            System.out.println("width of image is " + bufferedImage2.getWidth());
            System.out.println("height of image is " + bufferedImage2.getHeight());
            Raster raster = bufferedImage2.getData();
            System.out.println("bi.getDate() : type of the Raster is " + raster.getClass().getName());
            DataBuffer dataBuffer = raster.getDataBuffer();
            System.out.println("type of the DataBuffer is " + dataBuffer.getClass().getName());
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            System.out.println("size of pixel array is " + nArray.length);
            System.out.println("");
            WritableRaster writableRaster = bufferedImage2.getRaster();
            System.out.println("bi.getRaster() : type of the Raster is " + writableRaster.getClass().getName());
            DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
            System.out.println("type of DataBuffer is " + dataBuffer2.getClass().getName());
            nArray = ((DataBufferInt)dataBuffer2).getData();
            System.out.println("size of pixel array is " + nArray.length);
            System.out.println("raster bouds is " + writableRaster.getBounds());
            System.out.println("raster width=" + writableRaster.getWidth() + ", height=" + writableRaster.getHeight());
            System.out.println("raster minX=" + writableRaster.getMinX() + ", minY=" + writableRaster.getMinY());
            System.out.println("raster number bands (samples per pixel)=" + writableRaster.getNumBands());
            System.out.println("raster num data elements =" + writableRaster.getNumDataElements());
            System.out.println("");
            int n = writableRaster.getWidth();
            int n2 = writableRaster.getHeight();
            int n3 = writableRaster.getNumBands();
            int n4 = 8;
            boolean bl = true;
            boolean bl2 = false;
            String string = "NSCalibratedRGBColorSpace";
            int n5 = n * n3;
            int n6 = n3 * n4;
            SampleModel sampleModel = bufferedImage2.getSampleModel();
            System.out.println("type of the SampleModel is " + sampleModel.getClass().getName());
            int[] nArray2 = sampleModel.getSampleSize();
            System.out.println("length of sample size array is " + nArray2.length);
            System.out.println("samples are :");
            for (int i = 0; i < nArray2.length; ++i) {
                int n7 = nArray2[i];
                System.out.print("" + i + ": " + n7 + ", ");
            }
            System.out.println("");
            if (sampleModel.getClass() == SinglePixelPackedSampleModel.class) {
                System.out.println("scanline stride is " + ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride());
            }
        }
    }

    private void setIsArmed(boolean bl) {
        this.showingPopoup = bl;
        if (this.nativePeerExists) {
            this.setIsArmedNative(this.nsStatusItemWrapperPointer, bl);
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (this.menu != null) {
            this.menu.setLightWeightPopupEnabled(false);
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    MacTrayIconService.this.setIsArmed(false);
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    MacTrayIconService.this.setIsArmed(false);
                }
            });
            popupParentFrame.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                }

                public void windowLostFocus(WindowEvent windowEvent) {
                    MacTrayIconService.this.menu.setVisible(false);
                }
            });
        }
    }

    public void processEvent(int n, int n2, int n3) {
    }

    public static synchronized void notifyEvent(int n, final int n2, final int n3, final int n4) {
        final MacTrayIconService macTrayIconService = (MacTrayIconService)map.get(new Integer(n));
        if (macTrayIconService == null) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    macTrayIconService.processEvent(n2, n3, n4);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.observer != null) {
            this.observer.setUpdate(false);
            this.observer = null;
        }
        this.observer = new AnimationObserver();
        if (this.icon instanceof ImageIcon) {
            this.observer = new AnimationObserver();
            ((ImageIcon)this.icon).setImageObserver(this.observer);
        }
        this.updateIcon();
    }

    public void setCaption(String string) {
        this.caption = string;
        if (this.nativePeerExists) {
            this.setTitleNative(this.nsStatusItemWrapperPointer, this.caption);
        }
    }

    public void setToolTip(String string) {
        this.toolTipText = string;
        if (this.nativePeerExists) {
            this.setToolTipNative(this.nsStatusItemWrapperPointer, this.toolTipText);
        }
    }

    public void setIconAutoSize(boolean bl) {
        this.autoSize = bl;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionList.remove(actionListener);
    }

    public Point getLocationOnScreen() {
        Point point = null;
        if (this.nativePeerExists) {
            float[] fArray = new float[4];
            this.getLocationOnScreenNative(this.nsStatusItemWrapperPointer, fArray);
            point = new Point((int)fArray[0], (int)fArray[1]);
        }
        return point;
    }

    void remove() {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MacTrayIconService.this.removeImpl();
                }
            };
            new Thread(runnable).start();
        } else {
            this.removeImpl();
        }
    }

    private synchronized void removeImpl() {
        if (this.observer != null) {
            this.observer.setUpdate(false);
        }
        if (this.nativePeerExists) {
            this.removeStatusItem(this.nsStatusItemWrapperPointer);
            this.nsStatusItemWrapperPointer = 0L;
            this.nativePeerExists = false;
        }
    }

    public void addBalloonActionListener(ActionListener actionListener) {
    }

    public void removeBalloonActionListener(ActionListener actionListener) {
    }

    void mouseEventCallback(String string, float f, float f2, final float f3) {
        if (("rightMouseDown".equals(string) || "mouseDown".equals(string)) && this.menu != null) {
            if (this.showingPopoup) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        MacTrayIconService.this.menu.setVisible(false);
                    }
                };
                SwingUtilities.invokeLater(runnable);
                return;
            }
            if (!this.actionList.isEmpty() && "mouseDown".equals(string)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Iterator iterator = MacTrayIconService.this.actionList.iterator();
                        while (iterator.hasNext()) {
                            ActionListener actionListener = (ActionListener)iterator.next();
                            actionListener.actionPerformed(new ActionEvent(MacTrayIconService.this, 1001, "PressAction"));
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    popupParentFrame.pack();
                    popupParentFrame.setVisible(true);
                    MacTrayIconService.this.menu.show(popupParentFrame.getContentPane(), (int)f3, 22);
                    MacTrayIconService.this.menu.requestFocus();
                    popupParentFrame.toFront();
                    MacTrayIconService.this.setIsArmed(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showThreads() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            System.out.println("thread " + i + "+: " + thread.getName());
        }
        System.out.println("Current thread is : " + Thread.currentThread().getName());
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("You're in the EVENT DISPATCH thread buddy!!");
        } else {
            System.out.println("NOT the Event-dispatch thread!");
        }
    }

    synchronized void dispose() {
        this.remove();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private class AnimationObserver
    extends Component
    implements ImageObserver {
        boolean update = true;

        private AnimationObserver() {
        }

        public void setUpdate(boolean bl) {
            this.update = bl;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (this.update && ((n & 0x20) != 0 || (n & 0x10) != 0)) {
                MacTrayIconService.this.updateIcon();
            }
            return this.update;
        }
    }

    static class PopupParent
    extends JDialog {
        public PopupParent() {
            super((Frame)null, "JDIC Tray Icon");
            try {
                Method method = this.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
                method.invoke((Object)this, Boolean.TRUE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.setUndecorated(true);
            this.setBounds(0, 0, 0, 0);
        }
    }
}

