/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.googlelogin;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.googleapps.GoogleLoginCredentialsResult;
import com.google.android.googleapps.IGoogleLoginService;
import com.google.android.googleapps.LoginData;
import com.google.android.googlelogin.GoogleAppsVerifier;
import com.google.android.googlelogin.GoogleLoginServiceConstants;
import com.google.android.googlelogin.GoogleLoginServiceNotFoundException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class GoogleLoginServiceBlockingHelper {
    private static final String TAG = "GoogleLoginServiceBlockingHelper";
    private final Context mContext;
    private volatile IGoogleLoginService mGoogleLoginService = null;
    private Lock mGoogleLoginServiceLock = new ReentrantLock();
    private Condition mBindWaitCondition = this.mGoogleLoginServiceLock.newCondition();
    private ServiceConnection mServiceConnection;
    private Thread mServiceThread = null;
    private final int mMinDelaySecs;
    private final int mMaxDelaySecs;
    private final double mBackoffFactor;
    private int mDelay = this.mMinDelaySecs;
    private boolean mGlsVerified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOneAuthToken(Context context, String username, String service) throws AuthenticationException, GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper loginHelper = new GoogleLoginServiceBlockingHelper(context);
        try {
            String string = loginHelper.getAuthToken(username, service);
            return string;
        }
        finally {
            loginHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleLoginServiceBlockingHelper(Context context) throws GoogleLoginServiceNotFoundException {
        this.mMinDelaySecs = 5;
        this.mMaxDelaySecs = 300;
        this.mBackoffFactor = 2.0;
        this.mContext = context;
        if (!GoogleAppsVerifier.isServiceAvailable(context, "com.google.android.googleapps.GoogleLoginService")) {
            throw new GoogleLoginServiceNotFoundException(0);
        }
        this.mGoogleLoginServiceLock.lock();
        try {
            this.mServiceConnection = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName className, IBinder service) {
                    try {
                        GoogleLoginServiceBlockingHelper.this.mGoogleLoginServiceLock.lock();
                        GoogleLoginServiceBlockingHelper.this.mGlsVerified = GoogleAppsVerifier.isGoogleAppsVerified(GoogleLoginServiceBlockingHelper.this.mContext);
                        GoogleLoginServiceBlockingHelper.this.mServiceThread = Thread.currentThread();
                        GoogleLoginServiceBlockingHelper.this.mGoogleLoginService = IGoogleLoginService.Stub.asInterface(service);
                        GoogleLoginServiceBlockingHelper.this.mBindWaitCondition.signalAll();
                    }
                    finally {
                        GoogleLoginServiceBlockingHelper.this.mGoogleLoginServiceLock.unlock();
                    }
                }

                public void onServiceDisconnected(ComponentName className) {
                    GoogleLoginServiceBlockingHelper.this.mGoogleLoginServiceLock.lock();
                    GoogleLoginServiceBlockingHelper.this.mGoogleLoginService = null;
                    GoogleLoginServiceBlockingHelper.this.mGoogleLoginServiceLock.unlock();
                }
            };
            if (!this.mContext.bindService(GoogleLoginServiceConstants.SERVICE_INTENT, this.mServiceConnection, 1)) {
                throw new GoogleLoginServiceNotFoundException(0);
            }
        }
        finally {
            this.mGoogleLoginServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.mGoogleLoginServiceLock.lock();
        try {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
                this.mGoogleLoginService = null;
            }
        }
        finally {
            this.mGoogleLoginServiceLock.unlock();
        }
    }

    private void delay() {
        try {
            Thread.sleep((long)this.mDelay * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mDelay = (int)((double)this.mDelay * this.mBackoffFactor);
        if (this.mDelay > this.mMaxDelaySecs) {
            this.mDelay = this.mMaxDelaySecs;
        }
    }

    private void resetDelay() {
        this.mDelay = this.mMinDelaySecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGoogleLoginService getLoginService() throws GoogleLoginServiceNotFoundException {
        try {
            this.mGoogleLoginServiceLock.lock();
            if (this.mServiceThread != null && Thread.currentThread() == this.mServiceThread) {
                throw new IllegalStateException("calling GoogleLoginServiceBlockingHelper methods from your main thread can lead to deadlock");
            }
            while (this.mGoogleLoginService == null) {
                try {
                    this.mBindWaitCondition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.checkGoogleLoginServiceVerificationLocked();
            IGoogleLoginService iGoogleLoginService = this.mGoogleLoginService;
            return iGoogleLoginService;
        }
        finally {
            this.mGoogleLoginServiceLock.unlock();
        }
    }

    private void checkGoogleLoginServiceVerificationLocked() throws GoogleLoginServiceNotFoundException {
        if (this.mGoogleLoginService != null && !this.mGlsVerified) {
            throw new GoogleLoginServiceNotFoundException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAuthToken(Context context, String authToken) throws GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper h = new GoogleLoginServiceBlockingHelper(context);
        try {
            h.invalidateAuthToken(authToken);
        }
        finally {
            h.close();
        }
    }

    public void invalidateAuthToken(String authToken) throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                loginService.invalidateAuthToken(authToken);
                return;
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAccounts(Context context) throws GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper h = new GoogleLoginServiceBlockingHelper(context);
        try {
            String[] stringArray = h.getAccounts();
            return stringArray;
        }
        finally {
            h.close();
        }
    }

    public String[] getAccounts() throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                return loginService.getAccounts();
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccount(Context context, boolean requiresGoogle) throws GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper h = new GoogleLoginServiceBlockingHelper(context);
        try {
            String string = h.getAccount(requiresGoogle);
            return string;
        }
        finally {
            h.close();
        }
    }

    public String getAccount(boolean requiresGoogle) throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                return loginService.getAccount(requiresGoogle);
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAuthToken(Context context, String username, String service) throws AuthenticationException, GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper h = new GoogleLoginServiceBlockingHelper(context);
        try {
            String string = h.getAuthToken(username, service);
            return string;
        }
        finally {
            h.close();
        }
    }

    public String getAuthToken(String username, String service) throws AuthenticationException, GoogleLoginServiceNotFoundException {
        this.resetDelay();
        GoogleLoginCredentialsResult result = this.getCredentials(username, service, true);
        if (result.getCredentialsString() == null) {
            LoginData loginData;
            LoginData.Status status = null;
            Intent intent = result.getCredentialsIntent();
            if (intent != null && (loginData = (LoginData)intent.getParcelableExtra("loginData")) != null) {
                status = loginData.mStatus;
            }
            throw new AuthenticationException("unable to find auth token for account", status);
        }
        return result.getCredentialsString();
    }

    public GoogleLoginCredentialsResult getCredentials(String username, String service, boolean notifyAuthFailure) throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                return loginService.blockingGetCredentials(username, service, notifyAuthFailure);
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    public String peekCredentials(String username, String service) throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                return loginService.peekCredentials(username, service);
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAndroidId(Context context) throws GoogleLoginServiceNotFoundException {
        GoogleLoginServiceBlockingHelper h = new GoogleLoginServiceBlockingHelper(context);
        try {
            long l = h.getAndroidId();
            return l;
        }
        finally {
            h.close();
        }
    }

    public long getAndroidId() throws GoogleLoginServiceNotFoundException {
        this.resetDelay();
        while (true) {
            IGoogleLoginService loginService = this.getLoginService();
            try {
                return loginService.getAndroidId();
            }
            catch (RemoteException e) {
                this.delay();
                continue;
            }
            break;
        }
    }

    public class AuthenticationException
    extends Exception {
        private LoginData.Status mStatus;

        public AuthenticationException() {
        }

        public AuthenticationException(String message) {
            super(message);
        }

        public AuthenticationException(String message, Throwable cause) {
            super(message, cause);
        }

        public AuthenticationException(Throwable cause) {
            super(cause);
        }

        public AuthenticationException(String message, LoginData.Status status) {
            super(message);
            this.mStatus = status;
        }

        public AuthenticationException(LoginData.Status status) {
            this.mStatus = status;
        }

        public LoginData.Status getStatus() {
            return this.mStatus;
        }
    }
}

