/*
 * Decompiled with CFR 0.152.
 */
package com.twofortyfouram;

import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;

public final class SharedResources {
    private static final String LOGGING_CLASS_NAME = SharedResources.class.getSimpleName();
    protected static final String STRING_PLUGIN_MESSAGE = "plugin_dialog_message";
    protected static final String STRING_PLUGIN_INFORMATIVE_SETTING = "plugin_dialog_informative_setting";
    protected static final String STRING_PLUGIN_OPEN = "plugin_open";
    protected static final String STRING_ACTIVITY_NOT_AVAILABLE = "activity_unavailable";
    public static final String STRING_MENU_SAVE = "save";
    public static final String STRING_MENU_DONTSAVE = "dontsave";
    public static final String STRING_MENU_HELP = "help";
    public static final String DRAWABLE_MENU_SAVE = "icon_save";
    public static final String DRAWABLE_MENU_DONTSAVE = "icon_dontsave";
    public static final String DRAWABLE_MENU_HELP = "icon_help";
    public static final String DRAWABLE_LOCALE_BORDER = "locale_border";

    public static CharSequence getTextResource(PackageManager manager, String name) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("%s.getDrawableResource(): manager param was null", LOGGING_CLASS_NAME));
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException(String.format("%s.getDrawableResource(): name param was null or empty", LOGGING_CLASS_NAME));
        }
        try {
            Resources localeResources = manager.getResourcesForApplication("com.twofortyfouram.locale");
            return localeResources.getText(localeResources.getIdentifier(name, "string", "com.twofortyfouram.locale"));
        }
        catch (Exception e) {
            try {
                Resources localeResources = manager.getResourcesForApplication("edu.mit.locale");
                return localeResources.getText(localeResources.getIdentifier(name, "string", "edu.mit.locale"));
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Drawable getDrawableResource(PackageManager manager, String name) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("%s.getDrawableResource(): manager param was null", LOGGING_CLASS_NAME));
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException(String.format("%s.getDrawableResource(): name param was null or empty", LOGGING_CLASS_NAME));
        }
        try {
            Resources localeResources = manager.getResourcesForApplication("com.twofortyfouram.locale");
            return localeResources.getDrawable(localeResources.getIdentifier(name, "drawable", "com.twofortyfouram.locale"));
        }
        catch (Exception e) {
            try {
                Resources localeResources = manager.getResourcesForApplication("edu.mit.locale");
                String newName = name;
                if (DRAWABLE_MENU_DONTSAVE.equals(name)) {
                    newName = "icon_dontsave_color_40";
                } else if (DRAWABLE_MENU_SAVE.equals(name)) {
                    newName = "icon_save_color_40";
                } else if (DRAWABLE_MENU_HELP.equals(name)) {
                    newName = "icon_help_color_40";
                }
                return localeResources.getDrawable(localeResources.getIdentifier(newName, "drawable", "edu.mit.locale"));
            }
            catch (Exception e2) {
                return null;
            }
        }
    }
}

