/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Filters {
    static Predicate<DateValue> byDayFilter(final WeekdayNum[] days, final boolean weeksInYear, final Weekday wkst) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                int instance;
                Weekday dow0;
                int nDays;
                Weekday dow = Weekday.valueOf(date);
                if (weeksInYear) {
                    nDays = TimeUtils.yearLength(date.year());
                    dow0 = Weekday.firstDayOfWeekInMonth(date.year(), 1);
                    instance = TimeUtils.dayOfYear(date.year(), date.month(), date.day());
                } else {
                    nDays = TimeUtils.monthLength(date.year(), date.month());
                    dow0 = Weekday.firstDayOfWeekInMonth(date.year(), date.month());
                    instance = date.day() - 1;
                }
                int dateWeekNo = wkst.javaDayNum <= dow.javaDayNum ? 1 + instance / 7 : instance / 7;
                int i = days.length;
                while (--i >= 0) {
                    WeekdayNum day = days[i];
                    if (day.wday != dow) continue;
                    int weekNo = day.num;
                    if (0 == weekNo) {
                        return true;
                    }
                    if (weekNo < 0) {
                        weekNo = Util.invertWeekdayNum(day, dow0, nDays);
                    }
                    if (dateWeekNo != weekNo) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> byMonthDayFilter(final int[] monthDays) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                int nDays = TimeUtils.monthLength(date.year(), date.month());
                int i = monthDays.length;
                while (--i >= 0) {
                    int day = monthDays[i];
                    if (day < 0) {
                        day += nDays + 1;
                    }
                    if (day != date.day()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> weekIntervalFilter(final int interval, final Weekday wkst, final DateValue dtStart) {
        return new Predicate<DateValue>(){
            DateValue wkStart;
            {
                DTBuilder wkStartB = new DTBuilder(dtStart);
                wkStartB.day -= (7 + Weekday.valueOf((DateValue)dtStart).javaDayNum - wkst.javaDayNum) % 7;
                this.wkStart = wkStartB.toDate();
            }

            @Override
            public boolean apply(DateValue date) {
                int off;
                int daysBetween = TimeUtils.daysBetween(date, this.wkStart);
                if (daysBetween < 0) {
                    daysBetween += interval * 7 * (1 + daysBetween / (-7 * interval));
                }
                return 0 == (off = daysBetween / 7 % interval);
            }
        };
    }

    private Filters() {
    }
}

