/*
 * Decompiled with CFR 0.152.
 */
package org.evilsoft.pathfinder.reference.api.contracts;

import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;
import org.evilsoft.pathfinder.reference.api.contracts.SectionContract;

public class SpellContract {
    public static final String AUTHORITY = "org.evilsoft.pathfinder.reference.api.spell";
    public static final Uri SPELL_LIST_URI = Uri.parse((String)"content://org.evilsoft.pathfinder.reference.api.spell/spells");
    public static final Uri SPELL_FILTER_LIST_URI = Uri.parse((String)"content://org.evilsoft.pathfinder.reference.api.spell/spells/filtered");
    public static final String SPELL_LIST_CONTENT_TYPE = "vnd.android.cursor.dir/org.evilsoft.pathfinder.reference.api.class.list";
    public static final String CLASS_SPELL_LIST_CONTENT_TYPE = "vnd.android.cursor.dir/org.evilsoft.pathfinder.reference.api.class.spell.list";

    public static final Uri getSpellHtmlUri(String spellId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.spell/spells/" + spellId + ".html"));
    }

    public static final Uri getSpellJsonUri(String spellId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.spell/spells/" + spellId + ".json"));
    }

    public static final Uri getClassSpellList(String classId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.spell/classes/" + classId + "/spells"));
    }

    public static final Uri getFilteredClassSpellList(String classId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.spell/classes/" + classId + "/spells/filtered"));
    }

    private SpellContract() {
    }

    public final class ClassSpellListColumns
    implements BaseColumns {
        public static final String SOURCE = "source";
        public static final String TYPE = "type";
        public static final String SUBTYPE = "subtype";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String CONTENT_URL = "content_url";
        public static final String CLASS = "class";
        public static final String LEVEL = "level";
        public static final String MAGIC_TYPE = "magic_type";
        public static final String SCHOOL = "school";
        public static final String SUBSCHOOL = "subschool";
        public static final String DESCRIPTOR = "descriptor";
        public static final String COMPONENTS = "components";

        private ClassSpellListColumns() {
        }
    }

    public static class SpellContractUtils
    extends SectionContract.SectionContractUtils {
        public static String getSchool(Cursor cursor) {
            return cursor.getString(7);
        }

        public static String getSubschool(Cursor cursor) {
            return cursor.getString(8);
        }

        public static String getDescriptor(Cursor cursor) {
            return cursor.getString(9);
        }

        public static String getClasses(Cursor cursor) {
            return cursor.getString(10);
        }

        public static String getComponents(Cursor cursor) {
            return cursor.getString(11);
        }
    }

    public final class SpellListColumns
    implements BaseColumns {
        public static final String SOURCE = "source";
        public static final String TYPE = "type";
        public static final String SUBTYPE = "subtype";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String CONTENT_URL = "content_url";
        public static final String SCHOOL = "school";
        public static final String SUBSCHOOL = "subschool";
        public static final String DESCRIPTOR = "descriptor";
        public static final String CLASSES = "classes";
        public static final String COMPONENTS = "components";

        private SpellListColumns() {
        }
    }

    public static class SpellListContractUtils
    extends SectionContract.SectionContractUtils {
        public static String getClass(Cursor cursor) {
            return cursor.getString(7);
        }

        public static Integer getLevel(Cursor cursor) {
            return cursor.getInt(8);
        }

        public static String getMagicType(Cursor cursor) {
            return cursor.getString(9);
        }

        public static String getSchool(Cursor cursor) {
            return cursor.getString(10);
        }

        public static String getSubschool(Cursor cursor) {
            return cursor.getString(11);
        }

        public static String getDescriptor(Cursor cursor) {
            return cursor.getString(12);
        }

        public static String getComponents(Cursor cursor) {
            return cursor.getString(13);
        }
    }
}

