/*
 * Decompiled with CFR 0.152.
 */
package org.evilsoft.pathfinder.reference.api.contracts;

import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;

public final class SectionContract {
    public static final String AUTHORITY = "org.evilsoft.pathfinder.reference.api.section";
    public static final Uri SECTION_LIST_URI = Uri.parse((String)"content://org.evilsoft.pathfinder.reference.api.section/sections");
    public static final String SECTION_LIST_CONTENT_TYPE = "vnd.android.cursor.dir/org.evilsoft.pathfinder.reference.api.section.list";

    public static final Uri getSectionHtmlUri(String sectionId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.section/sections/" + sectionId + ".html"));
    }

    public static final Uri getSectionJsonUri(String sectionId) {
        return Uri.parse((String)("content://org.evilsoft.pathfinder.reference.api.section/sections/" + sectionId + ".json"));
    }

    private SectionContract() {
    }

    public static class SectionContractUtils {
        public static Integer getId(Cursor cursor) {
            return cursor.getInt(0);
        }

        public static String getSource(Cursor cursor) {
            return cursor.getString(1);
        }

        public static String getType(Cursor cursor) {
            return cursor.getString(2);
        }

        public static String getSubType(Cursor cursor) {
            return cursor.getString(3);
        }

        public static String getName(Cursor cursor) {
            return cursor.getString(4);
        }

        public static String getDescription(Cursor cursor) {
            return cursor.getString(5);
        }

        public static String getContentUrl(Cursor cursor) {
            return cursor.getString(6);
        }
    }

    public final class SectionListColumns
    implements BaseColumns {
        public static final String SOURCE = "source";
        public static final String TYPE = "type";
        public static final String SUBTYPE = "subtype";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String CONTENT_URL = "content_url";

        private SectionListColumns() {
        }
    }
}

